/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jca.context;

import javax.resource.spi.BootstrapContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.jca.context.BootstrapContextAware;

class BootstrapContextAwareProcessor
implements BeanPostProcessor {
    private final BootstrapContext bootstrapContext;

    public BootstrapContextAwareProcessor(BootstrapContext bootstrapContext) {
        this.bootstrapContext = bootstrapContext;
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean2, String beanName) throws BeansException {
        if (this.bootstrapContext != null && bean2 instanceof BootstrapContextAware) {
            ((BootstrapContextAware)bean2).setBootstrapContext(this.bootstrapContext);
        }
        return bean2;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean2, String beanName) throws BeansException {
        return bean2;
    }
}

