/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.infrastructure.persistence.message;

import br.pucrio.tecgraf.soma.job.JobHistoryEvent;
import br.pucrio.tecgraf.soma.job.SomaJobHistoryConsumer;
import br.pucrio.tecgraf.soma.job.application.appservice.JobHistoryEventService;
import br.pucrio.tecgraf.soma.job.application.appservice.LostEventAppService;
import br.pucrio.tecgraf.soma.job.infrastructure.persistence.message.JobHistoryEventReader;
import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JobHistoryEventReader {
    private final Logger logger = LoggerFactory.getLogger(SomaJobHistoryConsumer.class);
    private JobHistoryEventService jobHistoryEventService;
    private LostEventAppService lostEventAppService;
    private RecordReader recordReader;

    @Autowired
    public JobHistoryEventReader(JobHistoryEventService jobHistoryEventService, LostEventAppService lostEventAppService) {
        this.jobHistoryEventService = jobHistoryEventService;
        this.lostEventAppService = lostEventAppService;
        this.recordReader = new RecordReader(this, null);
    }

    public void run(String kafkaServer, String schemaRegistryUrl, String statusTopic, String progressTopic, String group) throws IOException, InterruptedException {
        KafkaConsumer consumer = this.buildKafkaConsumer(kafkaServer, schemaRegistryUrl, group);
        ArrayList<String> topics = new ArrayList<String>();
        topics.add(statusTopic);
        topics.add(progressTopic);
        consumer.subscribe(topics);
        while (!Thread.currentThread().isInterrupted()) {
            this.readRecords(consumer, statusTopic);
        }
    }

    protected void readRecords(KafkaConsumer<String, JobHistoryEvent> consumer, String statusTopic) throws InterruptedException, IOException {
        ConsumerRecords records = consumer.poll(Duration.ofMillis(100L));
        this.logger.debug("Got {} records from Kafka", (Object)records.count());
        for (TopicPartition partition : records.partitions()) {
            List partitionRecords = records.records(partition);
            for (ConsumerRecord record : partitionRecords) {
                this.recordReader.readRecord(consumer, partition, statusTopic, partitionRecords, record);
            }
        }
    }

    protected KafkaConsumer<String, JobHistoryEvent> buildKafkaConsumer(String kafkaServer, String schemaRegistryUrl, String group) {
        return new KafkaConsumer(this.buildProperties(kafkaServer, schemaRegistryUrl, group));
    }

    private Properties buildProperties(String kafkaServer, String schemaRegistryUrl, String group) {
        Properties properties = new Properties();
        properties.setProperty("bootstrap.servers", kafkaServer);
        properties.setProperty("key.deserializer", StringDeserializer.class.getName());
        properties.setProperty("value.deserializer", KafkaAvroDeserializer.class.getName());
        properties.setProperty("schema.registry.url", schemaRegistryUrl);
        properties.setProperty("specific.avro.reader", "true");
        properties.setProperty("group.id", group);
        properties.setProperty("enable.auto.commit", "false");
        properties.setProperty("auto.offset.reset", "earliest");
        return properties;
    }

    static /* synthetic */ Logger access$100(JobHistoryEventReader x0) {
        return x0.logger;
    }

    static /* synthetic */ JobHistoryEventService access$200(JobHistoryEventReader x0) {
        return x0.jobHistoryEventService;
    }

    static /* synthetic */ LostEventAppService access$300(JobHistoryEventReader x0) {
        return x0.lostEventAppService;
    }
}

