package br.pucrio.tecgraf.soma.job.application.service.job.builder;

import br.pucrio.tecgraf.soma.job.domain.model.JobStatusHistory;
import br.pucrio.tecgraf.soma.job.domain.model.StatusType;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;

abstract class AbstractJobBuilder {
  private LocalDateTime LocalDateTimeFromTimestamp(long timestamp) {
    return LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneOffset.UTC);
  }

  JobStatusHistory newJobStatusHistory(StatusType status, long timestamp) {
    JobStatusHistory jobStatusHistory = new JobStatusHistory();
    jobStatusHistory.setStatus(status);
    jobStatusHistory.setTimestamp(LocalDateTimeFromTimestamp(timestamp));
    return jobStatusHistory;
  }
}
