/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.application.appservice;

import br.pucrio.tecgraf.soma.job.api.model.JobPagination;
import br.pucrio.tecgraf.soma.job.application.Tuple;
import br.pucrio.tecgraf.soma.job.application.service.JobService;
import br.pucrio.tecgraf.soma.job.domain.model.Job;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class JobAppService {
    @Autowired
    JobService service;

    @Transactional
    public void markJobAsDeleted(String jobId) {
        this.service.markJobAsDeleted(jobId);
    }

    @Transactional
    public void markJobsAsDeleted(List<String> jobIds) {
        this.service.markJobsAsDeleted(jobIds);
    }

    @Transactional
    public Tuple<List<Job>, Integer> findJobs(String rsqlQuery, Integer offset, Integer limit, Boolean ascending, String sortAttribute) {
        List jobs = this.service.findJobs(rsqlQuery, offset, limit, ascending, sortAttribute);
        int total = (int)this.service.count(rsqlQuery);
        return new Tuple((Object)jobs, (Object)total);
    }

    public JobPagination buildPaginationInfo(Integer total, Integer offset, Integer limit) {
        JobPagination pagination = new JobPagination();
        pagination.total(total);
        pagination.limit(limit);
        if (offset == null) {
            pagination.offset(Integer.valueOf(0));
        } else {
            int newOffset = offset >= total ? (total == 0 ? 0 : (total % limit == 0 ? total - limit : total - total % limit)) : offset;
            pagination.offset(Integer.valueOf(newOffset));
        }
        return pagination;
    }
}

