/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.application.service;

import br.pucrio.tecgraf.soma.job.domain.model.Job;
import br.pucrio.tecgraf.soma.job.infrastructure.persistence.repository.JobRepository;
import br.pucrio.tecgraf.soma.job.infrastructure.persistence.specification.JobByIdSpecification;
import br.pucrio.tecgraf.soma.job.infrastructure.persistence.specification.JobsInListSpecification;
import br.pucrio.tecgraf.soma.serviceapi.persistence.repository.Sort;
import br.pucrio.tecgraf.soma.serviceapi.persistence.specification.JPASpecification;
import br.pucrio.tecgraf.soma.serviceapi.persistence.specification.impl.RSQLSpecification;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class JobService {
    @Autowired
    private JobRepository jobRepository;

    JobService(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    @Transactional
    public void markJobAsDeleted(String jobId) {
        Job job = (Job)this.jobRepository.first((JPASpecification)new JobByIdSpecification(jobId), new Sort[0]);
        job.setDeleted(true);
        this.jobRepository.update((Object)job);
    }

    @Transactional
    public void markJobsAsDeleted(List<String> jobIds) {
        JobsInListSpecification spec = new JobsInListSpecification(jobIds);
        List jobs = this.jobRepository.find((JPASpecification)spec, new Sort[0]);
        for (Job job : jobs) {
            job.setDeleted(true);
            this.jobRepository.update((Object)job);
        }
    }

    @Transactional
    public List<Job> findJobs(String rsqlQuery, Boolean ascending, String sortAttribute) {
        return this.findJobs(rsqlQuery, null, null, ascending, sortAttribute);
    }

    @Transactional
    public List<Job> findJobs(String rsqlQuery, Integer offset, Integer limit, Boolean ascending, String sortAttribute) {
        ArrayList<Sort> sorts = new ArrayList<Sort>();
        if (ascending != null) {
            sorts.add(new Sort(sortAttribute, ascending.booleanValue()));
        }
        return this.jobRepository.find((JPASpecification)new RSQLSpecification(rsqlQuery, this.jobRepository.getEntityManager()), limit, offset, sorts.toArray(new Sort[0]));
    }

    @Transactional
    public long count(String rsqlQuery) {
        return this.jobRepository.count((JPASpecification)new RSQLSpecification(rsqlQuery, this.jobRepository.getEntityManager()));
    }
}

