/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.application.controller;

import br.pucrio.tecgraf.soma.job.api.JobsApi;
import br.pucrio.tecgraf.soma.job.api.NotFoundException;
import br.pucrio.tecgraf.soma.job.api.model.JobData;
import br.pucrio.tecgraf.soma.job.api.model.JobPagination;
import br.pucrio.tecgraf.soma.job.api.model.JobResponse;
import br.pucrio.tecgraf.soma.job.application.Tuple;
import br.pucrio.tecgraf.soma.job.application.appservice.JobAppService;
import br.pucrio.tecgraf.soma.job.domain.dto.DomainMapper;
import br.pucrio.tecgraf.soma.job.domain.model.Job;
import br.pucrio.tecgraf.soma.job.domain.model.JobAlgorithm;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class JobController
extends JobsApi {
    @Autowired
    private JobAppService jobAppService;

    public JobController() {
        super(null);
    }

    public Response jobsDelete(List<String> jobIds, String locale, SecurityContext securityContext) throws NotFoundException {
        this.jobAppService.markJobsAsDeleted(jobIds);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    public Response jobsGet(String q, Integer offset, Integer limit, Boolean asc, String attr, Boolean showParam, String locale, SecurityContext securityContext) throws NotFoundException {
        if (limit != null && limit <= 0) {
            return Response.status((int)HttpStatus.BAD_REQUEST.value(), (String)"Limit must be a positive number").build();
        }
        if (offset != null && offset < 0) {
            return Response.status((int)HttpStatus.BAD_REQUEST.value(), (String)"Offset must be a positive number or zero").build();
        }
        if (offset != null && limit == null) {
            return Response.status((int)HttpStatus.BAD_REQUEST.value(), (String)"Limit is mandatory using offset").build();
        }
        String notDeletedQuery = "isDeleted==false";
        if (q == null || q.length() == 0) {
            q = notDeletedQuery;
        } else if (!q.contains("isDeleted")) {
            q = String.format("(%s);(%s)", q, notDeletedQuery);
        }
        Tuple tuple = this.jobAppService.findJobs(q, offset, limit, asc, attr);
        JobPagination pagination = this.jobAppService.buildPaginationInfo((Integer)tuple.getSecond(), offset, limit);
        if (offset != pagination.getOffset()) {
            tuple = this.jobAppService.findJobs(q, pagination.getOffset(), limit, asc, attr);
        }
        if (!showParam.booleanValue()) {
            for (Job job : (List)tuple.getFirst()) {
                for (JobAlgorithm algorithm : job.getAlgorithms()) {
                    algorithm.getParameters().clear();
                }
            }
        }
        JobData data = new JobData();
        data.processingDate(Long.valueOf(System.currentTimeMillis()));
        data.jobs(Arrays.asList((Object[])DomainMapper.convert((Object)tuple.getFirst(), br.pucrio.tecgraf.soma.job.api.model.Job[].class)));
        JobResponse response = new JobResponse();
        response.data(data);
        response.pagination(pagination);
        return Response.ok().entity((Object)response).build();
    }
}

