/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.api;

import br.pucrio.tecgraf.soma.job.api.NotFoundException;
import br.pucrio.tecgraf.soma.job.api.ReplicaApiService;
import br.pucrio.tecgraf.soma.job.api.factories.ReplicaApiServiceFactory;
import br.pucrio.tecgraf.soma.job.api.model.ReplicaJob;
import br.pucrio.tecgraf.soma.job.api.model.ReplicaJobResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.servlet.ServletConfig;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path(value="/replica")
@Api(description="the replica API")
public class ReplicaApi {
    private final ReplicaApiService delegate;

    public ReplicaApi(@Context ServletConfig servletContext) {
        String implClass;
        ReplicaApiService delegate = null;
        if (servletContext != null && (implClass = servletContext.getInitParameter("ReplicaApi.implementation")) != null && !"".equals(implClass.trim())) {
            try {
                delegate = (ReplicaApiService)Class.forName(implClass).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (delegate == null) {
            delegate = ReplicaApiServiceFactory.getReplicaApi();
        }
        this.delegate = delegate;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a replica submission", notes="This endpoint creates a replica submission from a multiflow.", response=ReplicaJobResponse.class, tags={"Replicas"})
    @ApiResponses(value={@ApiResponse(code=201, message="New replica job created.", response=ReplicaJobResponse.class), @ApiResponse(code=400, message="Missing body parameter(s).", response=Void.class), @ApiResponse(code=401, message="No authorization token.", response=Void.class), @ApiResponse(code=403, message="The authenticated user does not have permission to access the project.", response=Void.class), @ApiResponse(code=404, message="Multiflow not found.", response=Void.class), @ApiResponse(code=409, message="Job id already associated with a replica.", response=Void.class), @ApiResponse(code=500, message="Processing error occurred during the multiflow creation.", response=Void.class), @ApiResponse(code=503, message="Server is currently unable to handle the request.", response=Void.class)})
    public Response replicaPost(@ApiParam(value="Required information to create a replica submission", required=true) @NotNull @Valid ReplicaJob replicaJob, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.replicaPost(replicaJob, locale, securityContext);
    }
}

