/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.api.model;

import br.pucrio.tecgraf.soma.job.api.model.ExitStatus;
import br.pucrio.tecgraf.soma.job.api.model.JobAlgorithm;
import br.pucrio.tecgraf.soma.job.api.model.JobType;
import br.pucrio.tecgraf.soma.job.api.model.StatusChangeHistory;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;

public class Job {
    @JsonProperty(value="jobId")
    private String jobId;
    @JsonProperty(value="groupId")
    private String groupId;
    @JsonProperty(value="projectId")
    private String projectId;
    @JsonProperty(value="jobOwner")
    private String jobOwner;
    @JsonProperty(value="automaticallyMachineSelection")
    private Boolean automaticallyMachineSelection;
    @JsonProperty(value="submissionMachines")
    private List<String> submissionMachines = null;
    @JsonProperty(value="numberOfProcesses")
    private Integer numberOfProcesses;
    @JsonProperty(value="numberOfProcessesByMachine")
    private Integer numberOfProcessesByMachine;
    @JsonProperty(value="submissionTime")
    private String submissionTime;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="priority")
    private Integer priority;
    @JsonProperty(value="multipleExecution")
    private Boolean multipleExecution;
    @JsonProperty(value="jobType")
    private JobType jobType = null;
    @JsonProperty(value="numberOfAttempts")
    private Integer numberOfAttempts;
    @JsonProperty(value="executionMachine")
    private String executionMachine;
    @JsonProperty(value="endTime")
    private String endTime;
    @JsonProperty(value="exitCode")
    private Integer exitCode;
    @JsonProperty(value="guiltyNodeId")
    private String guiltyNodeId;
    @JsonProperty(value="exitStatus")
    private ExitStatus exitStatus = null;
    @JsonProperty(value="cpuTime")
    private Double cpuTime;
    @JsonProperty(value="wallclockTime")
    private Integer wallclockTime;
    @JsonProperty(value="ramMemory")
    private Double ramMemory;
    @JsonProperty(value="statusHistory")
    private List<StatusChangeHistory> statusHistory = null;
    @JsonProperty(value="algorithms")
    private List<JobAlgorithm> algorithms = null;
    @JsonProperty(value="flowId")
    private String flowId;
    @JsonProperty(value="flowVersion")
    private String flowVersion;
    @JsonProperty(value="flowName")
    private String flowName;
    @JsonProperty(value="lastModifiedTime")
    private String lastModifiedTime;

    public Job jobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    @JsonProperty(value="jobId")
    @ApiModelProperty(value="The job Id.")
    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public Job groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    @JsonProperty(value="groupId")
    @ApiModelProperty(value="The group Id of the job.")
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public Job projectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    @JsonProperty(value="projectId")
    @ApiModelProperty(value="The project Id associated with the job.")
    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public Job jobOwner(String jobOwner) {
        this.jobOwner = jobOwner;
        return this;
    }

    @JsonProperty(value="jobOwner")
    @ApiModelProperty(value="The id of the user who submitted the job.")
    public String getJobOwner() {
        return this.jobOwner;
    }

    public void setJobOwner(String jobOwner) {
        this.jobOwner = jobOwner;
    }

    public Job automaticallyMachineSelection(Boolean automaticallyMachineSelection) {
        this.automaticallyMachineSelection = automaticallyMachineSelection;
        return this;
    }

    @JsonProperty(value="automaticallyMachineSelection")
    @ApiModelProperty(value="If the user select a machine for execution or not.")
    public Boolean getAutomaticallyMachineSelection() {
        return this.automaticallyMachineSelection;
    }

    public void setAutomaticallyMachineSelection(Boolean automaticallyMachineSelection) {
        this.automaticallyMachineSelection = automaticallyMachineSelection;
    }

    public Job submissionMachines(List<String> submissionMachines) {
        this.submissionMachines = submissionMachines;
        return this;
    }

    public Job addSubmissionMachinesItem(String submissionMachinesItem) {
        if (this.submissionMachines == null) {
            this.submissionMachines = new ArrayList();
        }
        this.submissionMachines.add(submissionMachinesItem);
        return this;
    }

    @JsonProperty(value="submissionMachines")
    @ApiModelProperty(value="The selected machines for job execution. If the user choose the automatically machine selection, this information is empty.")
    public List<String> getSubmissionMachines() {
        return this.submissionMachines;
    }

    public void setSubmissionMachines(List<String> submissionMachines) {
        this.submissionMachines = submissionMachines;
    }

    public Job numberOfProcesses(Integer numberOfProcesses) {
        this.numberOfProcesses = numberOfProcesses;
        return this;
    }

    @JsonProperty(value="numberOfProcesses")
    @ApiModelProperty(value="The total number of job processes. In case of multiple execution, this number can be greater than one.")
    public Integer getNumberOfProcesses() {
        return this.numberOfProcesses;
    }

    public void setNumberOfProcesses(Integer numberOfProcesses) {
        this.numberOfProcesses = numberOfProcesses;
    }

    public Job numberOfProcessesByMachine(Integer numberOfProcessesByMachine) {
        this.numberOfProcessesByMachine = numberOfProcessesByMachine;
        return this;
    }

    @JsonProperty(value="numberOfProcessesByMachine")
    @ApiModelProperty(value="The number of job processes by machine. In case of multiple execution, this number can be greater than one.")
    public Integer getNumberOfProcessesByMachine() {
        return this.numberOfProcessesByMachine;
    }

    public void setNumberOfProcessesByMachine(Integer numberOfProcessesByMachine) {
        this.numberOfProcessesByMachine = numberOfProcessesByMachine;
    }

    public Job submissionTime(String submissionTime) {
        this.submissionTime = submissionTime;
        return this;
    }

    @JsonProperty(value="submissionTime")
    @ApiModelProperty(value="The submission time.")
    public String getSubmissionTime() {
        return this.submissionTime;
    }

    public void setSubmissionTime(String submissionTime) {
        this.submissionTime = submissionTime;
    }

    public Job description(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="description")
    @ApiModelProperty(value="The description provided by the user at submission. It can be empty.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Job priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @JsonProperty(value="priority")
    @ApiModelProperty(value="The priority of the job.")
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Job multipleExecution(Boolean multipleExecution) {
        this.multipleExecution = multipleExecution;
        return this;
    }

    @JsonProperty(value="multipleExecution")
    @ApiModelProperty(value="If the user requested a multiple execution.")
    public Boolean getMultipleExecution() {
        return this.multipleExecution;
    }

    public void setMultipleExecution(Boolean multipleExecution) {
        this.multipleExecution = multipleExecution;
    }

    public Job jobType(JobType jobType) {
        this.jobType = jobType;
        return this;
    }

    @JsonProperty(value="jobType")
    @ApiModelProperty(value="")
    @Valid
    public JobType getJobType() {
        return this.jobType;
    }

    public void setJobType(JobType jobType) {
        this.jobType = jobType;
    }

    public Job numberOfAttempts(Integer numberOfAttempts) {
        this.numberOfAttempts = numberOfAttempts;
        return this;
    }

    @JsonProperty(value="numberOfAttempts")
    @ApiModelProperty(value="The number of times the job has already been scheduled for execution.")
    public Integer getNumberOfAttempts() {
        return this.numberOfAttempts;
    }

    public void setNumberOfAttempts(Integer numberOfAttempts) {
        this.numberOfAttempts = numberOfAttempts;
    }

    public Job executionMachine(String executionMachine) {
        this.executionMachine = executionMachine;
        return this;
    }

    @JsonProperty(value="executionMachine")
    @ApiModelProperty(value="The machine where the job executed (or was scheduled to execute).")
    public String getExecutionMachine() {
        return this.executionMachine;
    }

    public void setExecutionMachine(String executionMachine) {
        this.executionMachine = executionMachine;
    }

    public Job endTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    @JsonProperty(value="endTime")
    @ApiModelProperty(value="The end time of the execution. It can be empty if the job have not already finished.")
    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public Job exitCode(Integer exitCode) {
        this.exitCode = exitCode;
        return this;
    }

    @JsonProperty(value="exitCode")
    @ApiModelProperty(value="The code returned by the job execution. It can be empty if the job have not already finished or if the system could not gather it.")
    public Integer getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(Integer exitCode) {
        this.exitCode = exitCode;
    }

    public Job guiltyNodeId(String guiltyNodeId) {
        this.guiltyNodeId = guiltyNodeId;
        return this;
    }

    @JsonProperty(value="guiltyNodeId")
    @ApiModelProperty(value="The id of the algorithm of the flow that caused the job to finish earlier than expected.")
    public String getGuiltyNodeId() {
        return this.guiltyNodeId;
    }

    public void setGuiltyNodeId(String guiltyNodeId) {
        this.guiltyNodeId = guiltyNodeId;
    }

    public Job exitStatus(ExitStatus exitStatus) {
        this.exitStatus = exitStatus;
        return this;
    }

    @JsonProperty(value="exitStatus")
    @ApiModelProperty(value="")
    @Valid
    public ExitStatus getExitStatus() {
        return this.exitStatus;
    }

    public void setExitStatus(ExitStatus exitStatus) {
        this.exitStatus = exitStatus;
    }

    public Job cpuTime(Double cpuTime) {
        this.cpuTime = cpuTime;
        return this;
    }

    @JsonProperty(value="cpuTime")
    @ApiModelProperty(value="")
    public Double getCpuTime() {
        return this.cpuTime;
    }

    public void setCpuTime(Double cpuTime) {
        this.cpuTime = cpuTime;
    }

    public Job wallclockTime(Integer wallclockTime) {
        this.wallclockTime = wallclockTime;
        return this;
    }

    @JsonProperty(value="wallclockTime")
    @ApiModelProperty(value="")
    public Integer getWallclockTime() {
        return this.wallclockTime;
    }

    public void setWallclockTime(Integer wallclockTime) {
        this.wallclockTime = wallclockTime;
    }

    public Job ramMemory(Double ramMemory) {
        this.ramMemory = ramMemory;
        return this;
    }

    @JsonProperty(value="ramMemory")
    @ApiModelProperty(value="")
    public Double getRamMemory() {
        return this.ramMemory;
    }

    public void setRamMemory(Double ramMemory) {
        this.ramMemory = ramMemory;
    }

    public Job statusHistory(List<StatusChangeHistory> statusHistory) {
        this.statusHistory = statusHistory;
        return this;
    }

    public Job addStatusHistoryItem(StatusChangeHistory statusHistoryItem) {
        if (this.statusHistory == null) {
            this.statusHistory = new ArrayList();
        }
        this.statusHistory.add(statusHistoryItem);
        return this;
    }

    @JsonProperty(value="statusHistory")
    @ApiModelProperty(value="")
    @Valid
    public List<StatusChangeHistory> getStatusHistory() {
        return this.statusHistory;
    }

    public void setStatusHistory(List<StatusChangeHistory> statusHistory) {
        this.statusHistory = statusHistory;
    }

    public Job algorithms(List<JobAlgorithm> algorithms) {
        this.algorithms = algorithms;
        return this;
    }

    public Job addAlgorithmsItem(JobAlgorithm algorithmsItem) {
        if (this.algorithms == null) {
            this.algorithms = new ArrayList();
        }
        this.algorithms.add(algorithmsItem);
        return this;
    }

    @JsonProperty(value="algorithms")
    @ApiModelProperty(value="")
    @Valid
    public List<JobAlgorithm> getAlgorithms() {
        return this.algorithms;
    }

    public void setAlgorithms(List<JobAlgorithm> algorithms) {
        this.algorithms = algorithms;
    }

    public Job flowId(String flowId) {
        this.flowId = flowId;
        return this;
    }

    @JsonProperty(value="flowId")
    @ApiModelProperty(value="The flow id associated with the job (if jobType == FLOW).")
    public String getFlowId() {
        return this.flowId;
    }

    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }

    public Job flowVersion(String flowVersion) {
        this.flowVersion = flowVersion;
        return this;
    }

    @JsonProperty(value="flowVersion")
    @ApiModelProperty(value="The flow version associated with the job (if jobType == FLOW).")
    public String getFlowVersion() {
        return this.flowVersion;
    }

    public void setFlowVersion(String flowVersion) {
        this.flowVersion = flowVersion;
    }

    public Job flowName(String flowName) {
        this.flowName = flowName;
        return this;
    }

    @JsonProperty(value="flowName")
    @ApiModelProperty(value="The flow name associated with the job (if jobType == FLOW).")
    public String getFlowName() {
        return this.flowName;
    }

    public void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public Job lastModifiedTime(String lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
        return this;
    }

    @JsonProperty(value="lastModifiedTime")
    @ApiModelProperty(value="The time of job last modification.")
    public String getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(String lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Job job = (Job)o;
        return Objects.equals(this.jobId, job.jobId) && Objects.equals(this.groupId, job.groupId) && Objects.equals(this.projectId, job.projectId) && Objects.equals(this.jobOwner, job.jobOwner) && Objects.equals(this.automaticallyMachineSelection, job.automaticallyMachineSelection) && Objects.equals(this.submissionMachines, job.submissionMachines) && Objects.equals(this.numberOfProcesses, job.numberOfProcesses) && Objects.equals(this.numberOfProcessesByMachine, job.numberOfProcessesByMachine) && Objects.equals(this.submissionTime, job.submissionTime) && Objects.equals(this.description, job.description) && Objects.equals(this.priority, job.priority) && Objects.equals(this.multipleExecution, job.multipleExecution) && Objects.equals(this.jobType, job.jobType) && Objects.equals(this.numberOfAttempts, job.numberOfAttempts) && Objects.equals(this.executionMachine, job.executionMachine) && Objects.equals(this.endTime, job.endTime) && Objects.equals(this.exitCode, job.exitCode) && Objects.equals(this.guiltyNodeId, job.guiltyNodeId) && Objects.equals(this.exitStatus, job.exitStatus) && Objects.equals(this.cpuTime, job.cpuTime) && Objects.equals(this.wallclockTime, job.wallclockTime) && Objects.equals(this.ramMemory, job.ramMemory) && Objects.equals(this.statusHistory, job.statusHistory) && Objects.equals(this.algorithms, job.algorithms) && Objects.equals(this.flowId, job.flowId) && Objects.equals(this.flowVersion, job.flowVersion) && Objects.equals(this.flowName, job.flowName) && Objects.equals(this.lastModifiedTime, job.lastModifiedTime);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.groupId, this.projectId, this.jobOwner, this.automaticallyMachineSelection, this.submissionMachines, this.numberOfProcesses, this.numberOfProcessesByMachine, this.submissionTime, this.description, this.priority, this.multipleExecution, this.jobType, this.numberOfAttempts, this.executionMachine, this.endTime, this.exitCode, this.guiltyNodeId, this.exitStatus, this.cpuTime, this.wallclockTime, this.ramMemory, this.statusHistory, this.algorithms, this.flowId, this.flowVersion, this.flowName, this.lastModifiedTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Job {\n");
        sb.append("    jobId: ").append(this.toIndentedString((Object)this.jobId)).append("\n");
        sb.append("    groupId: ").append(this.toIndentedString((Object)this.groupId)).append("\n");
        sb.append("    projectId: ").append(this.toIndentedString((Object)this.projectId)).append("\n");
        sb.append("    jobOwner: ").append(this.toIndentedString((Object)this.jobOwner)).append("\n");
        sb.append("    automaticallyMachineSelection: ").append(this.toIndentedString((Object)this.automaticallyMachineSelection)).append("\n");
        sb.append("    submissionMachines: ").append(this.toIndentedString((Object)this.submissionMachines)).append("\n");
        sb.append("    numberOfProcesses: ").append(this.toIndentedString((Object)this.numberOfProcesses)).append("\n");
        sb.append("    numberOfProcessesByMachine: ").append(this.toIndentedString((Object)this.numberOfProcessesByMachine)).append("\n");
        sb.append("    submissionTime: ").append(this.toIndentedString((Object)this.submissionTime)).append("\n");
        sb.append("    description: ").append(this.toIndentedString((Object)this.description)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString((Object)this.priority)).append("\n");
        sb.append("    multipleExecution: ").append(this.toIndentedString((Object)this.multipleExecution)).append("\n");
        sb.append("    jobType: ").append(this.toIndentedString((Object)this.jobType)).append("\n");
        sb.append("    numberOfAttempts: ").append(this.toIndentedString((Object)this.numberOfAttempts)).append("\n");
        sb.append("    executionMachine: ").append(this.toIndentedString((Object)this.executionMachine)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString((Object)this.endTime)).append("\n");
        sb.append("    exitCode: ").append(this.toIndentedString((Object)this.exitCode)).append("\n");
        sb.append("    guiltyNodeId: ").append(this.toIndentedString((Object)this.guiltyNodeId)).append("\n");
        sb.append("    exitStatus: ").append(this.toIndentedString((Object)this.exitStatus)).append("\n");
        sb.append("    cpuTime: ").append(this.toIndentedString((Object)this.cpuTime)).append("\n");
        sb.append("    wallclockTime: ").append(this.toIndentedString((Object)this.wallclockTime)).append("\n");
        sb.append("    ramMemory: ").append(this.toIndentedString((Object)this.ramMemory)).append("\n");
        sb.append("    statusHistory: ").append(this.toIndentedString((Object)this.statusHistory)).append("\n");
        sb.append("    algorithms: ").append(this.toIndentedString((Object)this.algorithms)).append("\n");
        sb.append("    flowId: ").append(this.toIndentedString((Object)this.flowId)).append("\n");
        sb.append("    flowVersion: ").append(this.toIndentedString((Object)this.flowVersion)).append("\n");
        sb.append("    flowName: ").append(this.toIndentedString((Object)this.flowName)).append("\n");
        sb.append("    lastModifiedTime: ").append(this.toIndentedString((Object)this.lastModifiedTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

