/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.infrastructure.persistence.repository;

import br.pucrio.tecgraf.soma.job.domain.model.JobView;
import br.pucrio.tecgraf.soma.serviceapi.persistence.repository.Sort;
import br.pucrio.tecgraf.soma.serviceapi.persistence.repository.impl.JPARepository;
import br.pucrio.tecgraf.soma.serviceapi.persistence.specification.JPASpecification;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Repository
public class JobViewRepository
extends JPARepository<JobView> {
    @PersistenceContext
    private EntityManager _entityManager;

    public Class<JobView> getType() {
        return JobView.class;
    }

    public EntityManager getEntityManager() {
        return this._entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this._entityManager = entityManager;
    }

    public List<JobView> find(JPASpecification<JobView> specification, Integer maxResult, Integer offset, Sort ... sorts) {
        List list;
        CriteriaBuilder criteriaBuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery innerQueryCriteria = criteriaBuilder.createQuery(JobView.class);
        Root fromIn = innerQueryCriteria.from(JobView.class);
        Predicate innerPredicate = specification.toPredicate(fromIn, criteriaBuilder);
        innerQueryCriteria.select((Selection)fromIn.get("jobId")).where((Expression)innerPredicate).groupBy(new Expression[]{fromIn.get("jobId")});
        for (Sort sort : sorts) {
            Expression orderAttr;
            if (sort.isAscending()) {
                orderAttr = criteriaBuilder.min((Expression)fromIn.get(sort.getAttribute()));
                innerQueryCriteria.orderBy(new Order[]{criteriaBuilder.asc(orderAttr)});
                continue;
            }
            orderAttr = criteriaBuilder.max((Expression)fromIn.get(sort.getAttribute()));
            innerQueryCriteria.orderBy(new Order[]{criteriaBuilder.desc(orderAttr)});
        }
        TypedQuery innerQuery = this.getEntityManager().createQuery(innerQueryCriteria);
        if (maxResult != null) {
            if (maxResult <= 0) {
                throw new IllegalArgumentException();
            }
            innerQuery.setMaxResults(maxResult.intValue());
        }
        if (offset != null) {
            if (offset < 0) {
                throw new IllegalArgumentException();
            }
            innerQuery.setFirstResult(offset.intValue());
        }
        if ((list = innerQuery.getResultList()).isEmpty()) {
            return list;
        }
        CriteriaQuery outerQueryCriteria = criteriaBuilder.createQuery(JobView.class);
        Root fromOut = outerQueryCriteria.from(JobView.class);
        outerQueryCriteria.select((Selection)fromOut).where((Expression)criteriaBuilder.in((Expression)fromOut.get("jobId")).value((Object)list));
        Order orderByJobStatusTimeAsc = criteriaBuilder.asc((Expression)fromOut.get("jobStatusTimestamp"));
        Order orderByJobAlgorithmIdAsc = criteriaBuilder.asc((Expression)fromOut.get("jaId"));
        Order orderByJobStatusHistoryIdAsc = criteriaBuilder.asc((Expression)fromOut.get("jobStatushistoryId"));
        for (Sort sort : sorts) {
            outerQueryCriteria.orderBy(new Order[]{sort.isAscending() ? criteriaBuilder.asc((Expression)fromOut.get(sort.getAttribute())) : criteriaBuilder.desc((Expression)fromOut.get(sort.getAttribute())), orderByJobStatusHistoryIdAsc, orderByJobStatusTimeAsc, orderByJobAlgorithmIdAsc});
        }
        return this.getEntityManager().createQuery(outerQueryCriteria).getResultList();
    }

    public long count(JPASpecification<JobView> specification) {
        CriteriaBuilder criteriaBuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery queryCriteria = criteriaBuilder.createQuery(Long.class);
        Root from = queryCriteria.from(JobView.class);
        Predicate innerPredicate = specification.toPredicate(from, criteriaBuilder);
        queryCriteria.select((Selection)criteriaBuilder.countDistinct((Expression)from.get("jobId"))).where((Expression)innerPredicate);
        return (Long)this.getEntityManager().createQuery(queryCriteria).getSingleResult();
    }
}

