/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.application.controller;

import br.pucrio.tecgraf.soma.job.api.JobsApi;
import br.pucrio.tecgraf.soma.job.api.model.Algorithm;
import br.pucrio.tecgraf.soma.job.api.model.AlgorithmResponse;
import br.pucrio.tecgraf.soma.job.api.model.JobData;
import br.pucrio.tecgraf.soma.job.api.model.JobPagination;
import br.pucrio.tecgraf.soma.job.api.model.JobResponse;
import br.pucrio.tecgraf.soma.job.api.model.NewComment;
import br.pucrio.tecgraf.soma.job.application.appservice.JobAppService;
import br.pucrio.tecgraf.soma.job.domain.dto.DomainMapper;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class JobController
extends JobsApi {
    @Autowired
    private JobAppService jobAppService;
    @Autowired
    private HttpServletRequest request;
    private static final int maxResultLimit = 1000;

    public JobController() {
        super(null);
    }

    public Response jobsHistoryAlgorithmsGet(String q, String locale, SecurityContext securityContext) throws ServiceUnavailableException {
        AlgorithmResponse response = new AlgorithmResponse();
        response.setProcessingDate(Long.valueOf(System.currentTimeMillis()));
        String accessToken = this.request.getHeader("Authorization");
        if (accessToken == null || accessToken.isEmpty()) {
            return Response.status((int)HttpStatus.UNAUTHORIZED.value()).build();
        }
        q = this.filterUserProjects(locale, accessToken, q);
        response.setAlgorithms(Arrays.asList((Object[])DomainMapper.convert((Object)this.jobAppService.findDistinctAlgorithms(q), Algorithm[].class)));
        return Response.ok().entity((Object)response).build();
    }

    public Response jobsHistoryJobIdCommentPut(String jobId, NewComment requestBody, String locale, SecurityContext securityContext) {
        String accessToken = this.request.getHeader("Authorization");
        if (accessToken == null || accessToken.isEmpty()) {
            return Response.status((int)HttpStatus.UNAUTHORIZED.value()).build();
        }
        if (requestBody == null || requestBody.getNewComment() == null) {
            return Response.status((int)HttpStatus.BAD_REQUEST.value(), (String)"Missing body with newComment parameter").build();
        }
        List userProjects = this.jobAppService.getUserProjects(locale, accessToken);
        this.jobAppService.editJobComment(jobId, requestBody.getNewComment(), userProjects);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    public Response jobsHistoryDelete(List<String> jobIds, String locale, SecurityContext securityContext) {
        this.jobAppService.markJobsAsDeleted(jobIds);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    public Response jobsHistoryGet(String q, Integer offset, Integer limit, Boolean asc, String attr, Boolean grouped, String locale, SecurityContext securityContext) {
        String accessToken;
        if (limit == null) {
            limit = 1000;
        } else if (limit <= 0 || limit > 1000) {
            return Response.status((int)HttpStatus.BAD_REQUEST.value(), (String)"Invalid limit value").build();
        }
        if (offset == null) {
            offset = 0;
        } else if (offset < 0) {
            return Response.status((int)HttpStatus.BAD_REQUEST.value(), (String)"Offset must be a positive number or zero").build();
        }
        if (asc == null) {
            asc = false;
        }
        if ((accessToken = this.request.getHeader("Authorization")) == null || accessToken.isEmpty()) {
            return Response.status((int)HttpStatus.UNAUTHORIZED.value()).build();
        }
        q = this.filterUserProjectsAndHandleDeleted(locale, accessToken, q);
        JobData data = new JobData();
        data.processingDate(Long.valueOf(System.currentTimeMillis()));
        JobPagination pagination = new JobPagination();
        pagination.setLimit(limit);
        JobResponse response = new JobResponse();
        response.data(data);
        response.pagination(pagination);
        if (grouped.booleanValue()) {
            this.jobAppService.findGroupedJobs(q, limit.intValue(), offset.intValue(), asc.booleanValue(), attr, response);
        } else {
            this.jobAppService.findJobs(q, limit.intValue(), offset.intValue(), asc.booleanValue(), attr, response);
        }
        return Response.ok().entity((Object)response).build();
    }

    public String filterUserProjects(String locale, String accessToken, String q) {
        String projectsQuery = this.getUserProjectsPredicate(locale, accessToken, "job.projectId");
        q = q == null || q.length() == 0 ? projectsQuery : String.format("(%s);(%s)", q, projectsQuery);
        return q;
    }

    public String filterUserProjectsAndHandleDeleted(String locale, String accessToken, String q) {
        String projectsQuery = this.getUserProjectsPredicate(locale, accessToken, "projectId");
        String baseQuery = "isDeleted==false;" + projectsQuery;
        q = q == null || q.length() == 0 ? baseQuery : (!q.contains("isDeleted") ? String.format("(%s);(%s)", q, baseQuery) : String.format("(%s);(%s)", q, projectsQuery));
        return q;
    }

    public String getUserProjectsPredicate(String locale, String accessToken, String projectColumn) {
        List projectIds = this.jobAppService.getUserProjects(locale, accessToken);
        if (projectIds.isEmpty()) {
            throw new NotFoundException("User has access to no projects");
        }
        StringBuilder projectsQuery = new StringBuilder(projectColumn);
        projectsQuery.append("=in=(");
        for (String projectId : projectIds) {
            projectsQuery.append(projectId);
            projectsQuery.append(",");
        }
        projectsQuery.deleteCharAt(projectsQuery.lastIndexOf(","));
        projectsQuery.append(")");
        return projectsQuery.toString();
    }
}

