/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.infrastructure.persistence.repository;

import br.pucrio.tecgraf.soma.job.domain.model.JobAlgorithm;
import br.pucrio.tecgraf.soma.serviceapi.persistence.repository.impl.JPARepository;
import br.pucrio.tecgraf.soma.serviceapi.persistence.specification.JPASpecification;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Repository
public class JobAlgorithmRepository
extends JPARepository<JobAlgorithm> {
    @PersistenceContext
    private EntityManager _entityManager;

    public Class<JobAlgorithm> getType() {
        return JobAlgorithm.class;
    }

    public EntityManager getEntityManager() {
        return this._entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this._entityManager = entityManager;
    }

    public List<JobAlgorithm> findDistinct(JPASpecification<JobAlgorithm> specification) {
        CriteriaBuilder criteriaBuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery queryCriteria = criteriaBuilder.createQuery(JobAlgorithm.class);
        Root from = queryCriteria.from(JobAlgorithm.class);
        Predicate condition = specification.toPredicate(from, criteriaBuilder);
        queryCriteria.multiselect(new Selection[]{from.get("algorithmId"), from.get("algorithmName")}).where((Expression)condition).groupBy(new Expression[]{from.get("algorithmId"), from.get("algorithmName")}).orderBy(new Order[]{criteriaBuilder.asc((Expression)from.get("algorithmName"))});
        TypedQuery query = this.getEntityManager().createQuery(queryCriteria);
        return query.getResultList();
    }
}

