package br.pucrio.tecgraf.soma.logsmonitor.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@EqualsAndHashCode(onlyExplicitlyIncluded = true)
@ToString
@JsonInclude(JsonInclude.Include.NON_NULL)
public class Message {
  public static final String JSON_PROPERTY_COMMAND = "command";
  public static final String JSON_PROPERTY_SUBSCRIPTION_ID = "subscriptionId";
  public static final String JSON_PROPERTY_TOPIC = "topic";
  public static final String JSON_PROPERTY_SEQNUM = "seqnum";
  @EqualsAndHashCode.Include private Command command;
  @EqualsAndHashCode.Include private String subscriptionId;
  @EqualsAndHashCode.Include private Topic topic;
  @EqualsAndHashCode.Include private Long seqnum;

  @JsonCreator
  public Message(
      @JsonProperty(value = JSON_PROPERTY_COMMAND, required = true) Command command,
      @JsonProperty(value = JSON_PROPERTY_SUBSCRIPTION_ID, required = true) String subscriptionId,
      @JsonProperty(value = JSON_PROPERTY_TOPIC, required = true) Topic topic,
      @JsonProperty(value = JSON_PROPERTY_SEQNUM, required = false) Long seqnum) {
    this.command = command;
    this.subscriptionId = subscriptionId;
    this.topic = topic;
    this.seqnum = seqnum;
  }
}
