package br.pucrio.tecgraf.soma.logsmonitor.model.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NonNull;
import lombok.ToString;

@Getter
@EqualsAndHashCode(onlyExplicitlyIncluded = true, callSuper = true)
@ToString
@JsonPropertyOrder({
  ErrorEvent.JSON_PROPERTY_TOPIC_EVENT_TYPE,
  InvalidMessageErrorEvent.JSON_PROPERTY_EXCEPTION_MESSAGE
})
public class InvalidMessageErrorEvent extends ErrorEvent {
  public static final String JSON_PROPERTY_EXCEPTION_MESSAGE = "exceptionMessage";
  @NonNull @EqualsAndHashCode.Include private final String message;

  @JsonCreator
  public InvalidMessageErrorEvent(
      @NonNull @JsonProperty(value = JSON_PROPERTY_EXCEPTION_MESSAGE, required = true)
          String message) {
    super(ErrorEventType.INVALID_MESSAGE_ERROR_EVENT);
    this.message = message;
  }
}
