package br.pucrio.tecgraf.soma.logsmonitor.model.mapper;

import br.pucrio.tecgraf.soma.logsmonitor.model.TopicType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service
public class TopicErrorsMapperFactory {
  private final Map<TopicType, TopicErrorsMapper> errorsMapperByTopic;

  @Autowired
  public TopicErrorsMapperFactory(List<TopicErrorsMapper> topicErrorsMappers) {
    errorsMapperByTopic =
        topicErrorsMappers.stream()
            .collect(Collectors.toMap(TopicErrorsMapper::getTopicType, Function.identity()));
  }

  public TopicErrorsMapper getEventMapperByTopicType(TopicType type) {
    return errorsMapperByTopic.get(type);
  }
}
