package br.pucrio.tecgraf.soma.logsmonitor.monitor;

import br.pucrio.tecgraf.soma.job.log.monitor.impl.JobLogMonitor;
import br.pucrio.tecgraf.soma.job.log.watcher.impl.DefaultFileWatcher;
import br.pucrio.tecgraf.soma.job.log.watcher.impl.PollingFileWatcher;
import br.pucrio.tecgraf.soma.job.log.watcher.interfaces.IFileWatcher;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.nio.charset.Charset;

@Configuration
public class MonitorConfiguration {

  @Value("${job.logs.monitor.reader.charset.default:ISO-8859-1}")
  public Charset defaultCharset;
  @Value("${job.logs.monitor.reader.charset.detection.enable:false}")
  public boolean enableCharsetDetection;
  @Value("${job.logs.monitor.reader.max.length.size:8192}")
  private Integer maxLengthSize;
  @Value("${job.logs.monitor.watcher.thread.pool.size:4}")
  private Integer watcherThreadPoolSize;
  @Value("${job.logs.monitor.watcher.polling.interval.ms:5000}")
  private Integer watcherPollingIntervalMillis;
  @Value("${job.logs.monitor.watcher.polling.enable:false}")
  public boolean enableWatcherPolling;

  @Bean(name = "JobLogsResourceMonitor")
  public ResourceMonitor jobLogsResourceMonitor() {
    return new JobLogMonitor(
        maxLengthSize, enableWatcherPolling, watcherThreadPoolSize, watcherPollingIntervalMillis, defaultCharset, enableCharsetDetection);
  }
}
