package br.pucrio.tecgraf.soma.logsmonitor.websocket;

import lombok.extern.apachecommons.CommonsLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;
import org.springframework.web.socket.handler.ExceptionWebSocketHandlerDecorator;
import org.springframework.web.socket.handler.LoggingWebSocketHandlerDecorator;
import org.springframework.web.socket.server.support.HttpSessionHandshakeInterceptor;

@Configuration
@EnableConfigurationProperties(WebSocketProperties.class)
@EnableWebSocket
@CommonsLog
public class WebSocketConfig implements WebSocketConfigurer {

  @Autowired private WebSocketProperties config;
  @Autowired private SocketHandler socketHandler;

  @Bean
  public WebSocketHandler socketHandlerDecorator() {
    return new ExceptionWebSocketHandlerDecorator(
        new LoggingWebSocketHandlerDecorator(socketHandler));
  }

  public void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
    log.info(String.format("CORS origins: %s", config.getCors().getOrigins()));
    registry
        .addHandler(socketHandlerDecorator(), "/" + config.getPath())
        .setAllowedOrigins(config.getCors().getOrigins().toArray(String[]::new))
        .addInterceptors(
            new HttpSessionHandshakeInterceptor(), new WebSocketHandshakeAuthJwtInterceptor());
  }
}
