/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.log.watcher.impl;

import br.pucrio.tecgraf.soma.job.log.watcher.impl.PollingFileWatcher;
import br.pucrio.tecgraf.soma.job.log.watcher.interfaces.IFileWatchEventListener;
import br.pucrio.tecgraf.soma.job.log.watcher.interfaces.IFileWatcher;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class JobLogFileWatcher
implements IFileWatcher {
    private List<String> monitoredFilePaths;
    private final IFileWatcher fileWatcher;

    public JobLogFileWatcher(List<IFileWatchEventListener> listeners) {
        this((IFileWatcher)new PollingFileWatcher(listeners, Integer.valueOf(1000)));
    }

    public JobLogFileWatcher(IFileWatcher watcher) {
        if (watcher == null) {
            throw new IllegalArgumentException("File Watcher cannot be null");
        }
        this.fileWatcher = watcher;
        this.initFilePaths();
    }

    public void register() throws IOException {
        String parentFileStrPath = this.getParentFilePath(this.monitoredFilePaths);
        this.fileWatcher.register(parentFileStrPath, (FileFilter)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected String getParentFilePath(List<String> fileStrPaths) {
        String fileStrPath = fileStrPaths.get(0);
        Path parentFilePath = Paths.get(fileStrPath, new String[0]).getParent();
        String parentFileStrAbsPath = parentFilePath.toFile().getAbsolutePath();
        for (int i = 1; i < fileStrPaths.size() - 1; ++i) {
            String childStrFilePath = fileStrPaths.get(i);
            Path parentChildFilePath = Paths.get(childStrFilePath, new String[0]).getParent();
            if (parentFileStrAbsPath.equals(parentChildFilePath.toFile().getAbsolutePath())) continue;
            throw new IllegalArgumentException("Monitoring files have not the same parent directory!");
        }
        return parentFileStrAbsPath;
    }

    public List<String> getMonitoredFilePaths() {
        return Collections.unmodifiableList(this.monitoredFilePaths);
    }

    public synchronized void addMonitoredFilePath(String filePath) {
        if (!this.monitoredFilePaths.contains(filePath)) {
            this.monitoredFilePaths.add(filePath);
        }
    }

    public synchronized void addAllMonitoredFilePath(List<String> filePaths) {
        if (!this.monitoredFilePaths.containsAll(filePaths)) {
            this.monitoredFilePaths.addAll(filePaths);
        }
    }

    public synchronized void removeMonitoredFilePath(String filePath) {
        this.monitoredFilePaths.remove(filePath);
    }

    public boolean isMonitoredFilePathsEmpty() {
        return this.monitoredFilePaths.isEmpty();
    }

    private void initFilePaths() {
        this.monitoredFilePaths = new CopyOnWriteArrayList();
    }

    public void startWatch() throws InterruptedException {
        this.fileWatcher.startWatch();
    }

    public void stopWatch() throws Exception {
        this.fileWatcher.stopWatch();
    }

    public void close() throws IOException {
        this.fileWatcher.close();
    }

    public void register(String dirStrPath, FileFilter filter) throws IOException {
        this.fileWatcher.register(dirStrPath, filter);
    }

    public void addFileWatchEventListener(IFileWatchEventListener listener) {
        this.fileWatcher.addFileWatchEventListener(listener);
    }

    public void removeFileWatchEventListener(IFileWatchEventListener listener) {
        this.fileWatcher.removeFileWatchEventListener(listener);
    }

    public boolean isWatching() {
        return this.fileWatcher.isWatching();
    }
}

