/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.log.watcher.impl;

import br.pucrio.tecgraf.soma.job.log.watcher.event.FileEvent;
import br.pucrio.tecgraf.soma.job.log.watcher.impl.PollingFileWatcher;
import br.pucrio.tecgraf.soma.job.log.watcher.interfaces.IFileWatchEventListener;
import br.pucrio.tecgraf.soma.job.log.watcher.interfaces.IFileWatcher;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingFileWatcher
implements IFileWatcher {
    private final Logger LOG = LoggerFactory.getLogger(PollingFileWatcher.class);
    private final List<IFileWatchEventListener> listeners;
    private Path watchedDirectoryPath;
    private FileAlterationObserver observer;
    private FileAlterationMonitor monitor;
    private volatile boolean isWatching = false;

    public PollingFileWatcher(Integer pollingIntervalMillis) throws IOException {
        this(new CopyOnWriteArrayList(), pollingIntervalMillis);
    }

    public PollingFileWatcher(List<IFileWatchEventListener> listeners, Integer pollingIntervalMillis) {
        this.monitor = new FileAlterationMonitor((long)pollingIntervalMillis.intValue());
        this.listeners = listeners;
    }

    public void register(String dirStrPath, FileFilter fileFilter) throws IOException {
        this.LOG.debug("[Polling Watcher] register [{}]", (Object)dirStrPath);
        this.watchedDirectoryPath = Paths.get(dirStrPath, new String[0]);
        if (!Files.isDirectory(this.watchedDirectoryPath, new LinkOption[0])) {
            String msg = String.format("The path %s is not a directory!", dirStrPath);
            this.LOG.error(msg);
            throw new IOException(msg);
        }
        this.LOG.info("Registering Polling Watcher for directory {} [Real path={}]", (Object)dirStrPath, (Object)this.getRealPath(this.watchedDirectoryPath));
        this.observer = new FileAlterationObserver(dirStrPath, fileFilter);
    }

    public void startWatch() throws InterruptedException {
        this.LOG.info("Polling Watcher Service starting...");
        try {
            this.observer.addListener((FileAlterationListener)new FileAlterationListenerImplementation(this));
            this.monitor.addObserver(this.observer);
            this.monitor.start();
            this.isWatching = true;
        }
        catch (Exception e) {
            this.LOG.debug("Polling Watcher Service could not be started...", (Throwable)e);
        }
    }

    public void stopWatch() throws Exception {
        this.LOG.info("Polling Watcher Service stopping...");
        this.monitor.stop();
        this.monitor.removeObserver(this.observer);
        this.isWatching = false;
    }

    public boolean isWatching() {
        return this.isWatching;
    }

    public void addFileWatchEventListener(IFileWatchEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeFileWatchEventListener(IFileWatchEventListener listener) {
        this.listeners.remove(listener);
    }

    public void close() throws IOException {
        this.LOG.debug("Polling Watcher was closed...");
        try {
            this.stopWatch();
        }
        catch (Exception e) {
            throw new IOException("Polling Watcher error on closing: ", e);
        }
    }

    protected synchronized void processEvent(File file) {
        FileEvent fe = new FileEvent(file);
        this.LOG.info("Polling Watcher Service notifying change event for file {} [Real path={}]", (Object)file, (Object)this.getRealPath(file.toPath()));
        for (IFileWatchEventListener listener : this.listeners) {
            listener.onFileModified(fe);
        }
    }

    private Path getRealPath(Path path) {
        Path realPath = null;
        try {
            realPath = path.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            this.LOG.error("Erro while getting real path for {}", (Object)path);
        }
        return realPath;
    }
}

