/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.logsmonitor.flow;

import br.pucrio.tecgraf.soma.logsmonitor.flow.TopicSubscriber;
import br.pucrio.tecgraf.soma.logsmonitor.model.Topic;
import br.pucrio.tecgraf.soma.logsmonitor.model.error.ErrorType;
import br.pucrio.tecgraf.soma.logsmonitor.monitor.ResourceMonitorEvent;
import br.pucrio.tecgraf.soma.logsmonitor.monitor.ResourceMonitorListener;
import br.pucrio.tecgraf.soma.logsmonitor.websocket.WebSocketNotificatioErrorService;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.concurrent.SubmissionPublisher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class TopicPublisher {
    private static final Log logger = LogFactory.getLog(TopicPublisher.class);
    private final SubmissionPublisher<ResourceMonitorEvent> delegate;
    private final Map<String, TopicSubscriber> subscribers;
    private final Topic topic;
    private final Integer topicUUID;
    private final ResourceMonitorListener<ResourceMonitorEvent> listener;
    private Flow.Subscription monitorSubscription;
    @Autowired
    private WebSocketNotificatioErrorService webSocketErrorService;

    public TopicPublisher(Topic topic) {
        logger.debug((Object)String.format("Topic [%s]: new TopicPublisher", topic));
        this.topic = topic;
        this.topicUUID = topic.getUUID();
        this.delegate = new SubmissionPublisher();
        this.subscribers = new HashMap();
        this.listener = new /* Unavailable Anonymous Inner Class!! */;
    }

    public Topic getTopic() {
        return this.topic;
    }

    public ResourceMonitorListener<ResourceMonitorEvent> getListener() {
        return this.listener;
    }

    public synchronized boolean hasSubscribers() {
        return !this.subscribers.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicPublisher that = (TopicPublisher)o;
        return this.topicUUID.equals(that.topicUUID);
    }

    public int hashCode() {
        return Objects.hash(this.topicUUID);
    }

    public synchronized boolean isSubscribed(String sessionId) {
        return this.subscribers.containsKey(sessionId);
    }

    public synchronized void subscribe(String sessionId, TopicSubscriber subscriber) {
        logger.debug((Object)String.format("Topic [%s]: subscribing session [%s]", this.topic, sessionId));
        if (!this.subscribers.containsKey(sessionId)) {
            this.delegate.subscribe(subscriber);
            this.subscribers.put(subscriber.getSessionId(), subscriber);
        }
        logger.debug((Object)String.format("Topic [%s]: active sessions numbers [%d]", this.topic, this.subscribers.keySet().size()));
    }

    public synchronized void unsubscribe(String sessionId) {
        logger.debug((Object)String.format("Topic [%s]: unsubscribing session [%s]", this.topic, sessionId));
        TopicSubscriber subscriber = (TopicSubscriber)this.subscribers.remove(sessionId);
        subscriber.onComplete();
        logger.debug((Object)String.format("Topic [%s]: active sessions numbers [%d]", this.topic, this.subscribers.keySet().size()));
        if (!this.hasSubscribers()) {
            logger.debug((Object)String.format("Topic [%s]: removing listener from monitor", this.topic));
            if (this.monitorSubscription != null) {
                this.monitorSubscription.cancel();
            }
            this.delegate.close();
        }
    }

    private synchronized void notifyError(String detailsErrorMsg) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("details", detailsErrorMsg);
        for (String sessionId : this.subscribers.keySet()) {
            TopicSubscriber subscriber = (TopicSubscriber)this.subscribers.get(sessionId);
            this.webSocketErrorService.onErrorNotify(sessionId, subscriber.getSubscriptionId(), ErrorType.RESOURCE_ERROR, "Internal error in monitor", map);
        }
    }
}

