/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.logsmonitor.websocket;

import br.pucrio.tecgraf.soma.logsmonitor.appservice.JobLogsAppService;
import br.pucrio.tecgraf.soma.logsmonitor.manager.PublisherManager;
import br.pucrio.tecgraf.soma.logsmonitor.manager.WebSocketSessionManager;
import br.pucrio.tecgraf.soma.logsmonitor.model.Message;
import br.pucrio.tecgraf.soma.logsmonitor.model.error.ErrorType;
import br.pucrio.tecgraf.soma.logsmonitor.websocket.WebSocketNotificatioErrorService;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.ConcurrentWebSocketSessionDecorator;
import org.springframework.web.socket.handler.TextWebSocketHandler;

@Component
public class SocketHandler
extends TextWebSocketHandler {
    private static final Log logger = LogFactory.getLog(SocketHandler.class);
    private final Integer sendTimeLimit = 10000;
    private final Integer bufferSizeLimit = 0xA00000;
    @Autowired
    private WebSocketSessionManager webSocketSessionManager;
    @Autowired
    private WebSocketNotificatioErrorService webSocketErrorService;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private PublisherManager publisherManager;
    @Autowired
    private JobLogsAppService appService;

    public void afterConnectionEstablished(WebSocketSession session) {
        ConcurrentWebSocketSessionDecorator concurrentSession = new ConcurrentWebSocketSessionDecorator(session, this.sendTimeLimit.intValue(), this.bufferSizeLimit.intValue());
        this.webSocketSessionManager.putSession(session.getId(), (WebSocketSession)concurrentSession);
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) throws Exception {
        this.webSocketSessionManager.removeSession(session.getId());
        this.publisherManager.onSessionClosed(session.getId());
        super.afterConnectionClosed(session, status);
    }

    public void handleTextMessage(WebSocketSession session, TextMessage message) throws Exception {
        Message topicMessage = null;
        try {
            topicMessage = (Message)this.objectMapper.readValue((String)message.getPayload(), Message.class);
            ConcurrentWebSocketSessionDecorator concurrentSession = new ConcurrentWebSocketSessionDecorator(session, this.sendTimeLimit.intValue(), this.bufferSizeLimit.intValue());
            this.appService.processMessage(topicMessage, (WebSocketSession)concurrentSession);
        }
        catch (JsonParseException e) {
            String errorMsg = String.format("Error deserializing message from %s: invalid JSON", session.getRemoteAddress());
            String subsId = this.getSubscriptionId((String)message.getPayload());
            this.notifyInvalidMessageError(session.getId(), subsId, errorMsg);
        }
        catch (JsonMappingException | IllegalArgumentException e) {
            String errorMsg = String.format("Error deserializing message from %s: %s: %s", session.getRemoteAddress(), e.getClass().getSimpleName(), e.getMessage());
            String subsId = this.getSubscriptionId((String)message.getPayload());
            this.notifyInvalidMessageError(session.getId(), subsId, errorMsg);
        }
    }

    private void notifyInvalidMessageError(String sessionId, String subscriptionId, String errorMsg) {
        logger.error((Object)errorMsg);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("exceptionMessage", errorMsg);
        this.webSocketErrorService.onErrorNotify(sessionId, subscriptionId, ErrorType.INVALID_MESSAGE, "Invalid Message", map);
    }

    private String getSubscriptionId(String playload) throws JsonProcessingException {
        JsonNode jsonNode = this.objectMapper.readTree(playload);
        return jsonNode.has("subscriptionId") ? jsonNode.get("subscriptionId").asText() : "";
    }
}

