package br.pucrio.tecgraf.soma.logsmonitor.manager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.WebSocketSession;

import java.util.Hashtable;
import java.util.Map;

@Component
public class WebSocketSessionManager {
  private static final Log logger = LogFactory.getLog(WebSocketSessionManager.class);

  private Map<String, WebSocketSession> sessions = new Hashtable<>();

  public void putSession(String id, WebSocketSession session) {
    this.sessions.put(id, session);
    logger.debug(String.format("Added session %s", session));
    logger.debug(String.format("Active sessions: %d", sessions.size()));
  }

  public WebSocketSession removeSession(String id) {
    WebSocketSession session = sessions.remove(id);
    logger.debug(String.format("Removed session %s", session));
    logger.debug(String.format("Active sessions: %d", sessions.size()));
    return session;
  }

  public WebSocketSession getSession(String id) {
    WebSocketSession session = this.sessions.get(id);
    logger.debug(String.format("Retrieving session %s", session));
    return session;
  }
}
