package br.pucrio.tecgraf.soma.logsmonitor.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum Command {
  SUBSCRIBE("SUBSCRIBE"),
  UNSUBSCRIBE("UNSUBSCRIBE");

  private final String value;

  Command(String value) {
    this.value = value;
  }

  @JsonCreator
  public static Command fromValue(String value) {
    for (Command b : Command.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }
}
