package br.pucrio.tecgraf.soma.logsmonitor.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.Getter;
import lombok.NonNull;
import lombok.ToString;

@Getter
@ToString
@JsonPropertyOrder({
  DataChunk.JSON_PROPERTY_OFFSET,
  DataChunk.JSON_PROPERTY_LENGTH,
  DataChunk.JSON_PROPERTY_DATA
})
public class DataChunk {
  public static final String JSON_PROPERTY_OFFSET = "offset";
  public static final String JSON_PROPERTY_LENGTH = "length";
  public static final String JSON_PROPERTY_DATA = "data";

  @NonNull private final Long offset;
  @NonNull private final Integer length;
  @NonNull private final String data;

  @JsonCreator
  public DataChunk(
      @NonNull @JsonProperty(value = JSON_PROPERTY_OFFSET, required = true) Long offset,
      @NonNull @JsonProperty(value = JSON_PROPERTY_LENGTH, required = true) Integer length,
      @NonNull @JsonProperty(value = JSON_PROPERTY_DATA, required = true) String data) {
    this.data = data;
    this.offset = offset;
    this.length = length;
  }
}
