package br.pucrio.tecgraf.soma.logsmonitor.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NonNull;
import lombok.ToString;

@Getter
@EqualsAndHashCode(onlyExplicitlyIncluded = true)
@ToString
@JsonPropertyOrder({
  Notification.JSON_PROPERTY_SUBSCRIPTION_ID,
  Notification.JSON_PROPERTY_TOPIC_TYPE,
  Notification.JSON_PROPERTY_EVENT
})
public class Notification {
  public static final String JSON_PROPERTY_SUBSCRIPTION_ID = "subscriptionId";
  public static final String JSON_PROPERTY_TOPIC_TYPE = "topicType";
  public static final String JSON_PROPERTY_EVENT = "topicEvent";
  @NonNull @EqualsAndHashCode.Include private final String subscriptionId;
  @NonNull @EqualsAndHashCode.Include private final TopicType topicType;
  @NonNull @EqualsAndHashCode.Include private final TopicEvent topicEvent;

  @JsonCreator
  public Notification(
      @NonNull @JsonProperty(value = JSON_PROPERTY_SUBSCRIPTION_ID, required = true)
          String subscriptionId,
      @NonNull @JsonProperty(value = JSON_PROPERTY_TOPIC_TYPE, required = true) TopicType topicType,
      @NonNull @JsonProperty(value = JSON_PROPERTY_EVENT, required = true) TopicEvent topicEvent) {
    this.subscriptionId = subscriptionId;
    this.topicType = topicType;
    this.topicEvent = topicEvent;
  }
}
