package br.pucrio.tecgraf.soma.logsmonitor.model;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.Getter;

@Getter
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "topicType")
@JsonSubTypes({@JsonSubTypes.Type(value = JobLogsTopic.class, name = "jobLogs")})
public abstract class Topic {
  public static final String JSON_PROPERTY_TOPIC_TYPE = "topicType";
  protected TopicType topicType;

  public TopicType getTopicType() {
    return topicType;
  }

  public void setTopicType(TopicType topicType) {
    this.topicType = topicType;
  }

  public abstract Integer getUUID();

  public abstract boolean equals(Object other);

  public abstract int hashCode();
}
