package br.pucrio.tecgraf.soma.logsmonitor.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum TopicEventType {
  JOBLOGSEVENT("jobLogsEvent");
  private final String value;

  TopicEventType(String value) {
    this.value = value;
  }

  @JsonCreator
  public static TopicEventType fromValue(String value) {
    for (TopicEventType b : TopicEventType.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }
}
