package br.pucrio.tecgraf.soma.logsmonitor.model.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NonNull;
import lombok.ToString;

@Getter
@EqualsAndHashCode(onlyExplicitlyIncluded = true, callSuper = true)
@ToString
@JsonPropertyOrder({
  ErrorEvent.JSON_PROPERTY_TOPIC_EVENT_TYPE,
  InvalidFieldValueErrorEvent.JSON_PROPERTY_FIELD_NAME,
  InvalidFieldValueErrorEvent.JSON_PROPERTY_FIELD_VALUE
})
public class InvalidFieldValueErrorEvent extends ErrorEvent {
  public static final String JSON_PROPERTY_FIELD_NAME = "fieldName";
  public static final String JSON_PROPERTY_FIELD_VALUE = "fieldValue";
  @NonNull @EqualsAndHashCode.Include private final String fieldName;
  @NonNull @EqualsAndHashCode.Include private final String fieldValue;

  @JsonCreator
  public InvalidFieldValueErrorEvent(
      @NonNull @JsonProperty(value = JSON_PROPERTY_FIELD_NAME, required = true) String fieldName,
      @NonNull @JsonProperty(value = JSON_PROPERTY_FIELD_VALUE, required = true)
          String fieldValue) {
    super(ErrorEventType.INVALID_FIELD_VALUE_ERROR_EVENT);
    this.fieldName = fieldName;
    this.fieldValue = fieldValue;
  }
}
