package br.pucrio.tecgraf.soma.logsmonitor.service;

import br.pucrio.tecgraf.soma.logsmonitor.model.TopicType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service
public class TopicServiceFactory {
  private final Map<TopicType, TopicService> servicesByTopic;

  /*
  O Spring irá injetar uma lista de todos os beans que implementam a interface TopicService.
   */
  @Autowired
  public TopicServiceFactory(List<TopicService> topicServices) {
    servicesByTopic =
        topicServices.stream()
            .collect(Collectors.toMap(TopicService::getTopicType, Function.identity()));
  }

  public TopicService getServiceByTopicType(TopicType type) {
    return servicesByTopic.get(type);
  }
}
