package br.pucrio.tecgraf.soma.logsmonitor.utils;

import org.apache.commons.lang3.StringUtils;

public class FileUtils {

  /**
   * Obtém um nome válido de diretório para a área base de logs dos jobs a partir de um nome com
   * caracteres especiais. As seguintes transformações são feitas:
   * <li>substituição de todos os caracteres acentuados pelo caractere correspondente sem o acento
   * <li>substituição de todos os caracteres fora do conjunto [a-zA-Z_0-9] por "_" (com exceção do
   *     caractere "-", que é aceito caso não esteja iniciando o nome do diretório).
   *
   * @param name nome potencialmente contendo caracteres especiais.
   * @return nome válido para a área de projeto (sem caracteres especiais).
   */
  public static String fixDirectoryName(String name) {
    return StringUtils.stripAccents(name).replaceAll("[^-\\w]", "_");
  }
}
