/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.logsmonitor.websocket;

import br.pucrio.tecgraf.soma.logsmonitor.websocket.SocketHandler;
import br.pucrio.tecgraf.soma.logsmonitor.websocket.WebSocketHandshakeAuthJwtInterceptor;
import br.pucrio.tecgraf.soma.logsmonitor.websocket.WebSocketProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;
import org.springframework.web.socket.handler.ExceptionWebSocketHandlerDecorator;
import org.springframework.web.socket.handler.LoggingWebSocketHandlerDecorator;
import org.springframework.web.socket.server.HandshakeInterceptor;
import org.springframework.web.socket.server.support.HttpSessionHandshakeInterceptor;

@Configuration
@EnableConfigurationProperties(value={WebSocketProperties.class})
@EnableWebSocket
public class WebSocketConfig
implements WebSocketConfigurer {
    private static final Log log = LogFactory.getLog(WebSocketConfig.class);
    @Autowired
    private WebSocketProperties config;
    @Autowired
    private SocketHandler socketHandler;

    @Bean
    public WebSocketHandler socketHandlerDecorator() {
        return new ExceptionWebSocketHandlerDecorator((WebSocketHandler)new LoggingWebSocketHandlerDecorator((WebSocketHandler)this.socketHandler));
    }

    public void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
        log.info((Object)String.format("CORS origins: %s", this.config.getCors().getOrigins()));
        registry.addHandler(this.socketHandlerDecorator(), new String[]{"/" + this.config.getPath()}).setAllowedOrigins((String[])this.config.getCors().getOrigins().toArray(String[]::new)).addInterceptors(new HandshakeInterceptor[]{new HttpSessionHandshakeInterceptor(), new WebSocketHandshakeAuthJwtInterceptor()});
    }
}

