/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.logsmonitor.websocket;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;
import org.springframework.web.util.UriComponentsBuilder;

public class WebSocketHandshakeAuthJwtInterceptor
implements HandshakeInterceptor {
    private static final Log logger = LogFactory.getLog(WebSocketHandshakeAuthJwtInterceptor.class);

    public boolean beforeHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Map<String, Object> attributes) throws Exception {
        String accessToken = this.getAuthToken(request);
        if (accessToken == null || accessToken.isEmpty()) {
            response.setStatusCode(HttpStatus.UNAUTHORIZED);
            logger.error((Object)String.format("There was an unauthorized request:\n", request.getHeaders().toString()));
            return false;
        }
        attributes.put("TOKEN", accessToken);
        return true;
    }

    private String getAuthToken(ServerHttpRequest request) {
        MultiValueMap queryParams = UriComponentsBuilder.fromHttpRequest((HttpRequest)request).build().getQueryParams();
        if (!queryParams.containsKey((Object)"token")) {
            return null;
        }
        List tokenParamValues = (List)queryParams.get((Object)"token");
        if (tokenParamValues.isEmpty()) {
            return null;
        }
        return (String)tokenParamValues.get(0);
    }

    public void afterHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Exception exception) {
    }
}

