/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.logsmonitor.websocket;

import br.pucrio.tecgraf.soma.logsmonitor.manager.WebSocketSessionManager;
import br.pucrio.tecgraf.soma.logsmonitor.model.error.ErrorEvent;
import br.pucrio.tecgraf.soma.logsmonitor.model.error.ErrorType;
import br.pucrio.tecgraf.soma.logsmonitor.model.error.InvalidFieldValueErrorEvent;
import br.pucrio.tecgraf.soma.logsmonitor.model.error.InvalidMessageErrorEvent;
import br.pucrio.tecgraf.soma.logsmonitor.model.error.MissingFieldErrorEvent;
import br.pucrio.tecgraf.soma.logsmonitor.model.error.NotificationError;
import br.pucrio.tecgraf.soma.logsmonitor.model.error.ProjectPermissionErrorEvent;
import br.pucrio.tecgraf.soma.logsmonitor.model.error.ResourceErrorEvent;
import br.pucrio.tecgraf.soma.logsmonitor.websocket.WebSocketNotificatioErrorService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

@Service
public class WebSocketNotificatioErrorService {
    private static final Log logger = LogFactory.getLog(WebSocketNotificatioErrorService.class);
    @Autowired
    ObjectMapper objectMapper;
    @Autowired
    private WebSocketSessionManager webSocketSessionManager;

    public void onErrorNotify(String sessionId, String subscriptionId, ErrorType errorType, String errorMsg, Map<String, Object> args) {
        String errorSubsId = subscriptionId == null ? "" : subscriptionId;
        ErrorEvent errorEvent = this.getErrorEvent(errorType, args);
        NotificationError notificationError = new NotificationError(errorSubsId, errorType, errorMsg, errorEvent);
        WebSocketSession session = this.webSocketSessionManager.getSession(sessionId);
        if (session != null) {
            try {
                if (session.isOpen()) {
                    session.sendMessage((WebSocketMessage)new TextMessage(this.objectMapper.writeValueAsBytes((Object)notificationError)));
                }
            }
            catch (IOException e) {
                logger.error((Object)"Cannot notify error message to websocket channel", (Throwable)e);
            }
        }
    }

    private ErrorEvent getErrorEvent(ErrorType errorType, Map<String, Object> args) {
        InvalidMessageErrorEvent errorEvent = null;
        switch (1.$SwitchMap$br$pucrio$tecgraf$soma$logsmonitor$model$error$ErrorType[errorType.ordinal()]) {
            case 1: {
                String exceptionMsg = (String)args.get("exceptionMessage");
                errorEvent = new InvalidMessageErrorEvent(exceptionMsg);
                break;
            }
            case 2: {
                String projectId = (String)args.get("projectId");
                errorEvent = new ProjectPermissionErrorEvent(projectId);
                break;
            }
            case 3: {
                String fieldName = (String)args.get("fieldName");
                errorEvent = new MissingFieldErrorEvent(fieldName);
                break;
            }
            case 4: {
                String invalidFieldName = (String)args.get("fieldName");
                String invalidFieldValue = String.valueOf(args.get("fieldValue"));
                errorEvent = new InvalidFieldValueErrorEvent(invalidFieldName, invalidFieldValue);
                break;
            }
            case 5: {
                String details = (String)args.get("details");
                errorEvent = new ResourceErrorEvent(details);
                break;
            }
            default: {
                logger.error((Object)("Unknown error type " + errorType));
            }
        }
        return errorEvent;
    }
}

