/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.log.reader;

import br.pucrio.tecgraf.soma.job.log.monitor.event.FileChunk;
import br.pucrio.tecgraf.soma.job.log.reader.FileReader;
import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileReader {
    private static final Logger LOG = LoggerFactory.getLogger(FileReader.class);
    private final Charset defaultCharset;
    private final boolean enableCharsetDetection;
    private final Integer maxLengthSize;

    public FileReader(Integer maxLengthSize, Charset defaultCharset, boolean enableCharsetDetection) {
        this.maxLengthSize = maxLengthSize;
        this.defaultCharset = defaultCharset;
        this.enableCharsetDetection = enableCharsetDetection;
    }

    private static void checkFileExistsAndIsReadable(File file) throws IOException {
        if (!file.exists() || !file.isFile()) {
            throw new IOException("File %s does not exists".formatted(file.getAbsolutePath()));
        }
        if (!file.canRead()) {
            throw new IOException("File %s is not readable".formatted(file.getAbsolutePath()));
        }
    }

    public Integer getMaxLengthSize() {
        return this.maxLengthSize;
    }

    public FileChunk readFile(String filePath, Long offset, Integer length, Charset charset) throws IOException {
        File file = new File(filePath);
        String fileName = file.getName();
        Long fileLength = file.length();
        if (offset == null || offset < 0L || offset > fileLength) {
            return null;
        }
        if (length == null) {
            length = Math.max(Math.toIntExact(fileLength - offset), 0);
        }
        try {
            FileReader.checkFileExistsAndIsReadable((File)file);
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            throw e;
        }
        Integer lengthToRead = Math.min(length, this.maxLengthSize);
        Charset charsetToUse = this.getCharset(file, charset);
        int paddingStart = 0;
        int paddingEnd = 0;
        if (charsetToUse == StandardCharsets.UTF_8) {
            paddingStart = this.adjustStartPadding(offset);
            paddingEnd = 3;
        }
        LOG.info("Reading file [{}, {}, {}] with charset {}", new Object[]{fileName, offset, lengthToRead, charsetToUse});
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            byte[] data;
            int paddingLength = lengthToRead + paddingStart + paddingEnd;
            byte[] buffer = new byte[paddingLength];
            long paddingOffset = offset;
            if (offset < fileLength) {
                paddingOffset = offset - (long)paddingStart;
            }
            raf.seek(paddingOffset);
            int bytesRead = raf.read(buffer);
            LOG.debug("Bytes read from file [{}]: {}", (Object)fileName, (Object)bytesRead);
            if (bytesRead <= 0) {
                LOG.debug("No data read from file [{}]", (Object)fileName);
                data = new byte[]{};
            } else if (paddingLength > bytesRead) {
                LOG.debug("Data read from file [{}] is less than length {}", (Object)fileName, (Object)lengthToRead);
                data = Arrays.copyOf(buffer, bytesRead);
            } else {
                LOG.debug("Data read from file [{}] is equal to length {}", (Object)fileName, (Object)lengthToRead);
                data = buffer;
            }
            byte[] finalData = data;
            long finalOffset = offset;
            if (data.length > 0 && charsetToUse == StandardCharsets.UTF_8) {
                paddingEnd = Math.min(paddingStart + lengthToRead, data.length) - 1;
                Tuple tuple = this.checkAndAdjustSplitUTF8Char(data, paddingStart, paddingEnd);
                finalData = tuple.data;
                finalOffset = offset - (long)tuple.offset;
            }
            String encodedData = new String(finalData, charsetToUse);
            FileChunk fileChunk = new FileChunk(Path.of(filePath, new String[0]), encodedData, Integer.valueOf(finalData.length), fileLength, Long.valueOf(finalOffset), charsetToUse);
            return fileChunk;
        }
    }

    private int adjustStartPadding(Long adjustedOffset) {
        if (adjustedOffset >= 3L) {
            return 3;
        }
        if (adjustedOffset == 2L) {
            return 2;
        }
        if (adjustedOffset == 1L) {
            return 1;
        }
        return 0;
    }

    private Tuple checkAndAdjustSplitUTF8Char(byte[] buffer, int paddingStart, int paddingEnd) {
        int dataStart = paddingStart;
        int dataEnd = paddingEnd;
        if ((dataStart = this.findUTF8CharStartAtPosition(buffer, dataStart)) > (dataEnd = this.findLastUTF8CharEndBeforePosition(buffer, dataEnd))) {
            dataEnd += this.getUTF8CharRemainingBytesNumber(buffer[dataStart]);
        }
        byte[] data = Arrays.copyOfRange(buffer, dataStart, dataEnd + 1);
        return new Tuple(paddingStart - dataStart, data);
    }

    private int getUTF8CharRemainingBytesNumber(byte byteChar) {
        byte res = (byte)(byteChar & 0xFFFFFFF8);
        switch (res) {
            case -64: {
                return 2;
            }
            case -32: {
                return 3;
            }
            case -16: {
                return 4;
            }
        }
        return 1;
    }

    private int findUTF8CharStartAtPosition(byte[] buffer, int currentPosition) {
        if ((buffer[currentPosition] & 0xFFFFFFC0) == -128) {
            int pos;
            for (pos = currentPosition; pos > 0 && (buffer[pos] & 0xFFFFFFC0) == -128; --pos) {
            }
            return pos;
        }
        return currentPosition;
    }

    private int findLastUTF8CharEndBeforePosition(byte[] buffer, int currentPosition) {
        int pos = this.findUTF8CharStartAtPosition(buffer, currentPosition);
        byte readByte = buffer[pos];
        if ((readByte & 0xFFFFFFE0) == -64) {
            if (currentPosition - pos + 1 == 2) {
                return currentPosition;
            }
            return pos - 1;
        }
        if ((readByte & 0xFFFFFFF0) == -32) {
            if (currentPosition - pos + 1 == 3) {
                return currentPosition;
            }
            return pos - 1;
        }
        if ((readByte & 0xFFFFFFF8) == -16) {
            if (currentPosition - pos + 1 == 4) {
                return currentPosition;
            }
            return pos - 1;
        }
        return pos;
    }

    protected Charset getCharset(File file, Charset forcedCharset) throws IOException {
        Charset charset = forcedCharset;
        if (forcedCharset != null) {
            LOG.debug("Using charset {} requested by client for file {}.", (Object)charset, (Object)file.getAbsolutePath());
            return charset;
        }
        if (!this.enableCharsetDetection) {
            charset = this.defaultCharset;
            LOG.debug("Using charset {} for file {}. Auto-detection is disabled.", (Object)charset, (Object)file.getAbsolutePath());
            return charset;
        }
        try (BufferedInputStream bs = new BufferedInputStream(new FileInputStream(file));){
            CharsetDetector charsetDetector = new CharsetDetector();
            charsetDetector.setText((InputStream)bs);
            charsetDetector.enableInputFilter(true);
            CharsetMatch cm = charsetDetector.detect();
            if (cm.getConfidence() > 80) {
                String UTF_8 = "UTF-8";
                String ISO_8859_1 = "ISO-8859-1";
                switch (cm.getName()) {
                    case "UTF-8": {
                        charset = StandardCharsets.UTF_8;
                        LOG.debug("Guessed charset {} with confidence {} for file {}", new Object[]{charset, cm.getConfidence(), file.getAbsolutePath()});
                        break;
                    }
                    case "ISO-8859-1": {
                        charset = StandardCharsets.ISO_8859_1;
                        LOG.debug("Guessed charset {} with confidence {} for file {}", new Object[]{charset, cm.getConfidence(), file.getAbsolutePath()});
                        break;
                    }
                    default: {
                        charset = this.defaultCharset;
                        LOG.debug("Using default charset {} for file {} because the guessed charset was not UTF-8 nor ISO-8859-1 [guessed charset {} with confidence {}]", new Object[]{charset, file.getAbsolutePath(), cm.getName(), cm.getConfidence()});
                        break;
                    }
                }
            } else {
                charset = this.defaultCharset;
                LOG.debug("Using default charset {} for file {} because the confidence was lower than 80 [guessed charset {} with confidence {}]", new Object[]{charset, file.getAbsolutePath(), cm.getName(), cm.getConfidence()});
            }
            Charset charset2 = charset;
            return charset2;
        }
    }
}

