/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.log.watcher.impl;

import br.pucrio.tecgraf.soma.job.log.watcher.event.FileEvent;
import br.pucrio.tecgraf.soma.job.log.watcher.interfaces.IFileWatchEventListener;
import br.pucrio.tecgraf.soma.job.log.watcher.interfaces.IFileWatcher;
import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFileWatcher
implements IFileWatcher {
    public static final WatchEvent.Modifier[] DEFAULT_MODIFIERS = new WatchEvent.Modifier[]{SensitivityWatchEventModifier.HIGH};
    private final Logger LOG = LoggerFactory.getLogger(DefaultFileWatcher.class);
    private final List<IFileWatchEventListener> listeners;
    private final WatchService watchService;
    private volatile boolean isWatching = false;
    private Path watchedDirectoryPath;
    private ExecutorService taskThreadPool;
    private FileFilter fileFilter;

    public DefaultFileWatcher(Integer threadPoolSize) throws IOException {
        this(FileSystems.getDefault().newWatchService(), new CopyOnWriteArrayList(), threadPoolSize);
    }

    public DefaultFileWatcher(WatchService watchService, List<IFileWatchEventListener> listeners, Integer threadPoolSize) {
        this.watchService = watchService;
        this.listeners = listeners;
        this.taskThreadPool = Executors.newFixedThreadPool(threadPoolSize);
    }

    public void register(String dirStrPath, FileFilter fileFilter) throws IOException {
        this.LOG.debug("[Default Watcher] registering path [{}]", (Object)dirStrPath);
        Path watchedDirectoryPath = Paths.get(dirStrPath, new String[0]);
        if (!Files.isDirectory(watchedDirectoryPath, new LinkOption[0])) {
            String msg = "The path %s is not a directory!".formatted(dirStrPath);
            this.LOG.error(msg);
            throw new IOException(msg);
        }
        this.LOG.info("Registering Default Watcher for change events on directory {} [Real path={}]", (Object)dirStrPath, (Object)this.getRealPath(watchedDirectoryPath));
        WatchEvent.Kind[] events = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY};
        watchedDirectoryPath.register(this.watchService, events, DEFAULT_MODIFIERS);
        this.watchedDirectoryPath = watchedDirectoryPath;
        this.fileFilter = fileFilter;
    }

    public void startWatch() throws InterruptedException {
        this.LOG.info("Default Watcher Service started...");
        this.isWatching = true;
        while (this.isWatching) {
            WatchKey key;
            try {
                key = this.watchService.take();
            }
            catch (ClosedWatchServiceException e) {
                this.LOG.debug("Default Watcher was closed on watch service close...");
                break;
            }
            if (key == null) continue;
            for (WatchEvent<?> watchEvent : key.pollEvents()) {
                this.LOG.debug("Got file changed event: {} with context: {}", watchEvent.kind(), watchEvent.context());
                this.taskThreadPool.execute(() -> this.processEvent(watchEvent));
            }
            key.reset();
        }
    }

    public void stopWatch() {
        this.isWatching = false;
    }

    public Path getWatchedDirectoryPath() {
        return this.watchedDirectoryPath;
    }

    public void addFileWatchEventListener(IFileWatchEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeFileWatchEventListener(IFileWatchEventListener listener) {
        this.listeners.remove(listener);
    }

    public void close() throws IOException {
        this.LOG.debug("Default Watcher was closed...");
        this.stopWatch();
        this.watchService.close();
    }

    public boolean isWatching() {
        return this.isWatching;
    }

    protected synchronized void processEvent(WatchEvent<?> watchEvent) {
        WatchEvent.Kind<?> kind = watchEvent.kind();
        WatchEvent<?> pathEvent = watchEvent;
        Path changedFilePath = (Path)pathEvent.context();
        File resolvedChangedFile = this.watchedDirectoryPath.resolve(changedFilePath).toFile();
        if (this.fileFilter == null || this.fileFilter.accept(resolvedChangedFile)) {
            FileEvent fe = new FileEvent(resolvedChangedFile);
            this.LOG.info("Default Watcher Service notifying change event for file {} [Real path={}]", (Object)resolvedChangedFile, (Object)this.getRealPath(resolvedChangedFile.toPath()));
            for (IFileWatchEventListener listener : this.listeners) {
                if (StandardWatchEventKinds.ENTRY_MODIFY != kind) continue;
                listener.onFileModified(fe);
            }
        }
    }

    private Path getRealPath(Path path) {
        Path realPath = null;
        try {
            realPath = path.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            this.LOG.error("Erro while getting real path for {}", (Object)path);
        }
        return realPath;
    }
}

