/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.logsmonitor.appservice;

import br.pucrio.tecgraf.soma.logsmonitor.appservice.JobLogsAppService;
import br.pucrio.tecgraf.soma.logsmonitor.model.Message;
import br.pucrio.tecgraf.soma.logsmonitor.model.error.ErrorType;
import br.pucrio.tecgraf.soma.logsmonitor.model.validator.MessageValidator;
import br.pucrio.tecgraf.soma.logsmonitor.service.TopicService;
import br.pucrio.tecgraf.soma.logsmonitor.service.TopicServiceFactory;
import br.pucrio.tecgraf.soma.logsmonitor.websocket.WebSocketNotificatioErrorService;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.web.socket.WebSocketSession;

@Service
public class JobLogsAppService {
    private static final Log logger = LogFactory.getLog(JobLogsAppService.class);
    @Autowired
    private TopicServiceFactory serviceFactory;
    @Autowired
    private MessageValidator messageValidator;
    @Autowired
    private WebSocketNotificatioErrorService webSocketErrorService;

    public void processMessage(Message message, WebSocketSession session) {
        TopicService service = this.serviceFactory.getServiceByTopicType(message.getTopic().getTopicType());
        if (this.messageHasErrors(message, session.getId())) {
            return;
        }
        switch (1.$SwitchMap$br$pucrio$tecgraf$soma$logsmonitor$model$Command[message.getCommand().ordinal()]) {
            case 1: {
                service.subscribe(message.getTopic(), session, message.getSubscriptionId(), message.getSeqnum());
                break;
            }
            case 2: {
                service.unsubscribe(session.getId(), message.getTopic());
            }
        }
    }

    private boolean messageHasErrors(Message message, String sessionId) {
        BeanPropertyBindingResult result = new BeanPropertyBindingResult((Object)message, "message");
        this.messageValidator.validate((Object)message, (Errors)result);
        if (result.hasErrors()) {
            FieldError fieldError = (FieldError)result.getFieldErrors().get(0);
            this.notifyValidationErrors(message.getSubscriptionId(), sessionId, fieldError);
            return true;
        }
        return false;
    }

    private void notifyValidationErrors(String subscriptionId, String sessionId, FieldError fieldError) {
        String errorMsg = fieldError.getDefaultMessage().formatted(fieldError.getField());
        logger.error((Object)errorMsg);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fieldName", fieldError.getField());
        map.put("fieldValue", fieldError.getRejectedValue());
        this.webSocketErrorService.onErrorNotify(sessionId, subscriptionId, ErrorType.INVALID_FIELD_VALUE_ERROR, errorMsg, map);
    }
}

