/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.logsmonitor.manager;

import br.pucrio.tecgraf.soma.logsmonitor.flow.TopicPublisher;
import br.pucrio.tecgraf.soma.logsmonitor.flow.TopicSubscriber;
import br.pucrio.tecgraf.soma.logsmonitor.manager.WebSocketSessionManager;
import br.pucrio.tecgraf.soma.logsmonitor.model.Topic;
import br.pucrio.tecgraf.soma.logsmonitor.model.mapper.TopicErrorsMapperFactory;
import br.pucrio.tecgraf.soma.logsmonitor.model.mapper.TopicEventMapper;
import br.pucrio.tecgraf.soma.logsmonitor.model.mapper.TopicEventMapperFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Lookup;
import org.springframework.stereotype.Component;

@Component
public class PublisherManager {
    private static final Log logger = LogFactory.getLog(PublisherManager.class);
    private final Map<Integer, TopicPublisher> publishersByTopic = new HashMap();
    private final Map<String, Set<TopicPublisher>> publishersBySession = new HashMap();
    @Autowired
    WebSocketSessionManager webSocketSessionManager;
    @Autowired
    TopicEventMapperFactory topicEventMapperFactory;
    @Autowired
    TopicErrorsMapperFactory topicErrorsMapperFactory;
    @Autowired
    ObjectMapper objectMapper;

    public synchronized TopicPublisher subscribe(Topic topic, Long initialSeqnum, String sessionId, String subscriptionId) throws IllegalArgumentException {
        logger.debug((Object)"Topic [%s]: add subscription for session [%s]".formatted(topic, sessionId));
        TopicPublisher publisher = this.getOrAddPublisherToTopicMap(topic);
        if (publisher.isSubscribed(sessionId)) {
            String errorMsg = "Topic [%s]: subscription for session [%s] already exists".formatted(publisher.getTopic(), sessionId);
            logger.debug((Object)errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        TopicEventMapper mapper = this.topicEventMapperFactory.getEventMapperByTopicType(topic.getTopicType());
        TopicSubscriber subscriber = this.getTopicSubscriber(sessionId, subscriptionId, publisher.getTopic(), mapper, initialSeqnum);
        publisher.subscribe(sessionId, subscriber);
        this.addPublisherToSessionMap(sessionId, publisher);
        return publisher;
    }

    private TopicPublisher getOrAddPublisherToTopicMap(Topic topic) {
        Integer topicUUID = topic.getUUID();
        TopicPublisher publisher = this.publishersByTopic.containsKey(topicUUID) ? (TopicPublisher)this.publishersByTopic.get(topicUUID) : this.getTopicPublisher(topic);
        logger.debug((Object)"Using publisher fot topic %s ".formatted(topic.getUUID()));
        this.publishersByTopic.putIfAbsent(topicUUID, publisher);
        return publisher;
    }

    private void addPublisherToSessionMap(String sessionId, TopicPublisher publisher) {
        Set sessionPublishers = this.publishersBySession.getOrDefault(sessionId, new HashSet());
        sessionPublishers.add(publisher);
        this.publishersBySession.putIfAbsent(sessionId, sessionPublishers);
    }

    public synchronized Optional<TopicPublisher> unsubscribe(Topic topic, String sessionId) {
        logger.debug((Object)"Topic [%s]: remove subscription from session [%s] ".formatted(topic, sessionId));
        TopicPublisher publisher = null;
        if (this.publishersByTopic.containsKey(topic.getUUID())) {
            publisher = (TopicPublisher)this.publishersByTopic.get(topic.getUUID());
            publisher.unsubscribe(sessionId);
            this.removePublisherFromSessionMap(sessionId, publisher);
            this.removePublisherFromTopicMap(topic, publisher);
        } else {
            logger.debug((Object)"Topic [%s]: does not exist".formatted(topic));
        }
        return Optional.ofNullable(publisher);
    }

    private void removePublisherFromSessionMap(String sessionId, TopicPublisher publisher) {
        if (this.publishersBySession.containsKey(sessionId)) {
            Set pubSet = (Set)this.publishersBySession.get(sessionId);
            pubSet.remove(publisher);
            if (pubSet.isEmpty()) {
                logger.debug((Object)"Session [%s]: remove session with zero subscriptions".formatted(sessionId));
                this.publishersBySession.remove(sessionId);
            }
        }
    }

    private void removePublisherFromTopicMap(Topic topic, TopicPublisher publisher) {
        if (!publisher.hasSubscribers()) {
            logger.debug((Object)"Topic [%s]: remove publisher with zero subscribers".formatted(topic));
            this.publishersByTopic.remove(topic.getUUID());
        }
    }

    public synchronized void onSessionClosed(String sessionId) {
        logger.debug((Object)"Session [%s]: remove all subscription".formatted(sessionId));
        if (this.publishersBySession.containsKey(sessionId)) {
            for (TopicPublisher publisher : (Set)this.publishersBySession.get(sessionId)) {
                publisher.unsubscribe(sessionId);
                this.removePublisherFromTopicMap(publisher.getTopic(), publisher);
            }
            this.publishersBySession.remove(sessionId);
        }
    }

    @Lookup
    public TopicPublisher getTopicPublisher(Topic topic) {
        return null;
    }

    @Lookup
    public TopicSubscriber getTopicSubscriber(String sessionId, String subscriptionId, Topic topic, TopicEventMapper mapper, Long initialSeqnum) {
        return null;
    }
}

