/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.logsmonitor.monitor;

import br.pucrio.tecgraf.soma.job.log.monitor.impl.JobLogMonitor;
import br.pucrio.tecgraf.soma.logsmonitor.monitor.ResourceMonitor;
import java.nio.charset.Charset;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MonitorConfiguration {
    @Value(value="${job.logs.monitor.reader.charset.default:ISO-8859-1}")
    public Charset defaultCharset;
    @Value(value="${job.logs.monitor.reader.charset.detection.enable:false}")
    public boolean enableCharsetDetection;
    @Value(value="${job.logs.monitor.reader.max.length.size:8192}")
    private Integer maxLengthSize;
    @Value(value="${job.logs.monitor.watcher.thread.pool.size:4}")
    private Integer watcherThreadPoolSize;
    @Value(value="${job.logs.monitor.watcher.polling.interval.ms:5000}")
    private Integer watcherPollingIntervalMillis;
    @Value(value="${job.logs.monitor.watcher.polling.enable:false}")
    public boolean enableWatcherPolling;

    @Bean(name={"JobLogsResourceMonitor"})
    public ResourceMonitor jobLogsResourceMonitor() {
        return new JobLogMonitor(this.maxLengthSize, this.enableWatcherPolling, this.watcherThreadPoolSize, this.watcherPollingIntervalMillis, this.defaultCharset, this.enableCharsetDetection);
    }
}

