/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.logsmonitor.service;

import br.pucrio.tecgraf.soma.logsmonitor.flow.TopicPublisher;
import br.pucrio.tecgraf.soma.logsmonitor.manager.PublisherManager;
import br.pucrio.tecgraf.soma.logsmonitor.model.JobLogsTopic;
import br.pucrio.tecgraf.soma.logsmonitor.model.Topic;
import br.pucrio.tecgraf.soma.logsmonitor.model.TopicType;
import br.pucrio.tecgraf.soma.logsmonitor.model.error.ErrorType;
import br.pucrio.tecgraf.soma.logsmonitor.monitor.ResourceMonitor;
import br.pucrio.tecgraf.soma.logsmonitor.monitor.ResourceMonitorEvent;
import br.pucrio.tecgraf.soma.logsmonitor.service.ProjectService;
import br.pucrio.tecgraf.soma.logsmonitor.service.ServiceException;
import br.pucrio.tecgraf.soma.logsmonitor.service.TopicService;
import br.pucrio.tecgraf.soma.logsmonitor.utils.CodeUtils;
import br.pucrio.tecgraf.soma.logsmonitor.utils.FileUtils;
import br.pucrio.tecgraf.soma.logsmonitor.websocket.WebSocketNotificatioErrorService;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.socket.WebSocketSession;

@Service
public class JobLogsTopicService
implements TopicService {
    private static final Log logger = LogFactory.getLog(JobLogsTopicService.class);
    @Value(value="${job.logs.monitor.rootdir}")
    public String rootDir;
    @Value(value="${job.logs.monitor.logsdir.pattern}")
    public String logsDirPattern;
    @Autowired
    private PublisherManager publisherManager;
    @Autowired
    @Qualifier(value="JobLogsResourceMonitor")
    private ResourceMonitor monitor;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private WebSocketNotificatioErrorService webSocketErrorService;

    public TopicType getTopicType() {
        return TopicType.JOBLOGS;
    }

    public boolean subscribe(Topic topic, WebSocketSession session, String subscriptionId, Long seqnum) {
        String sessionId = session.getId();
        String token = this.getToken(session);
        JobLogsTopic jobLogsTopic = (JobLogsTopic)topic;
        String decodedJobId = CodeUtils.decode((String)jobLogsTopic.getJobId());
        String decodedProjectId = CodeUtils.decode((String)jobLogsTopic.getProjectId());
        String jobsIdDecodedFixed = FileUtils.fixDirectoryName((String)decodedJobId);
        String resourceId = this.getLogsDirPath(jobsIdDecodedFixed, decodedProjectId, jobLogsTopic.getLogName());
        try {
            if (!this.userHasProjectPermission(token, decodedProjectId)) {
                this.notifyProjectPermissionError(subscriptionId, sessionId, "User has no project permission", decodedProjectId);
                return false;
            }
        }
        catch (ServiceException e) {
            this.notifyJobLogFileError(subscriptionId, sessionId, "Error while querying for user project permissions", e.getMessage());
            return false;
        }
        TopicPublisher publisher = null;
        try {
            publisher = this.publisherManager.subscribe((Topic)jobLogsTopic, seqnum, sessionId, subscriptionId);
        }
        catch (IllegalArgumentException e) {
            this.notifyJobLogFileError(subscriptionId, sessionId, "Error while subscribing to a topic", e.getMessage());
            return false;
        }
        HashMap<String, Comparable<Long>> params = new HashMap<String, Comparable<Long>>();
        params.put("timestamp", seqnum);
        params.put("encoding", jobLogsTopic.getEncoding());
        this.monitor.addListener(resourceId, publisher.getListener(), params);
        return true;
    }

    private boolean userHasProjectPermission(String token, String decodedProjectId) {
        return this.projectService.hasUserProjectPermission(token, decodedProjectId);
    }

    private void notifyProjectPermissionError(String subscriptionId, String sessionId, String shortErrorDescr, String projectId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("projectId", projectId);
        this.webSocketErrorService.onErrorNotify(sessionId, subscriptionId, ErrorType.PROJECT_PERMISSION_ERROR, shortErrorDescr, map);
    }

    private void notifyJobLogFileError(String subscriptionId, String sessionId, String shortErrorDescr, String detailsErrorMsg) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("details", detailsErrorMsg);
        this.webSocketErrorService.onErrorNotify(sessionId, subscriptionId, ErrorType.RESOURCE_ERROR, shortErrorDescr, map);
    }

    public boolean unsubscribe(String sessionId, Topic topic) {
        JobLogsTopic jobLogsTopic = (JobLogsTopic)topic;
        Optional publisherOptional = this.publisherManager.unsubscribe((Topic)jobLogsTopic, sessionId);
        return true;
    }

    public List<ResourceMonitorEvent> getEvents(Topic topic, Long startSeqnum, Long endSeqnum) {
        JobLogsTopic jobLogsTopic = (JobLogsTopic)topic;
        String decodedJobId = CodeUtils.decode((String)jobLogsTopic.getJobId());
        String decodedProjectId = CodeUtils.decode((String)jobLogsTopic.getProjectId());
        String jobsIdDecodedFixed = FileUtils.fixDirectoryName((String)decodedJobId);
        String resourceId = this.getLogsDirPath(jobsIdDecodedFixed, decodedProjectId, jobLogsTopic.getLogName());
        return this.monitor.getEvents(resourceId, startSeqnum, endSeqnum);
    }

    private String getLogsDirPath(String jobId, String projectId, String fileName) {
        String logsDirPath = this.logsDirPattern;
        logsDirPath = logsDirPath.replaceAll("__ROOT__", this.rootDir);
        logsDirPath = logsDirPath.replaceAll("__PROJECT__", projectId);
        logsDirPath = logsDirPath.replaceAll("__JOB__", jobId);
        logger.debug((Object)"Reading file data from path: %s".formatted(logsDirPath));
        return Paths.get(logsDirPath, fileName).toAbsolutePath().toString();
    }

    private String base64Decode(String s) throws IllegalArgumentException {
        return new String(Base64.getUrlDecoder().decode(s));
    }

    private String getToken(WebSocketSession session) {
        return (String)session.getAttributes().get("TOKEN");
    }
}

