/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.logsmonitor.service;

import br.pucrio.tecgraf.soma.logsmonitor.service.ServiceException;
import java.time.Duration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientRequestException;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

@Service
public class ProjectService {
    private final Logger logger = LoggerFactory.getLogger(ProjectService.class);
    @Value(value="${job.logs.monitor.services.projectService.projectPermission.path}")
    private String projectsPermissionPath;
    @Value(value="${job.logs.monitor.services.projectService.projectPermission.enable}")
    private Boolean projectsPermissionCheck;
    private WebClient webClient;

    public ProjectService(@Value(value="${job.logs.monitor.services.projectService.clientBaseUrl}") String clientBaseUrl) {
        this.webClient = WebClient.builder().baseUrl(clientBaseUrl).defaultHeader("Content-Type", new String[]{"application/json"}).build();
    }

    public List<String> getUserProjects(String accessToken) throws WebClientResponseException {
        Mono response = this.webClient.get().uri(this.projectsPermissionPath, new Object[0]).headers(headers -> headers.setBearerAuth(accessToken)).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).timeout(Duration.ofMillis(60000L));
        List projects = (List)response.block();
        return projects;
    }

    public boolean hasUserProjectPermission(String accessToken, String projectId) {
        try {
            if (!this.projectsPermissionCheck.booleanValue()) {
                this.logger.info("Skipping project permission check");
                return true;
            }
            this.logger.info("Checking user permission to project %s".formatted(projectId));
            Mono response = this.webClient.get().uri(this.projectsPermissionPath, new Object[0]).headers(headers -> headers.setBearerAuth(accessToken)).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).flatMap(list -> {
                for (String p : list) {
                    if (!p.equals(projectId)) continue;
                    return Mono.just((Object)true);
                }
                return Mono.just((Object)false);
            });
            return (Boolean)response.block();
        }
        catch (WebClientRequestException e) {
            throw new ServiceException(e.getMessage());
        }
        catch (WebClientResponseException ex) {
            throw new ServiceException(ex.getMessage(), ex.getRawStatusCode());
        }
    }
}

