/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.BoundaryNodeRule;
import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryCollectionIterator;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;

public class PointLocator {
    private BoundaryNodeRule boundaryRule = BoundaryNodeRule.ENDPOINT_BOUNDARY_RULE;
    private boolean isIn;
    private int numBoundaries;

    public PointLocator() {
    }

    public PointLocator(BoundaryNodeRule boundaryRule) {
        if (boundaryRule == null) {
            throw new IllegalArgumentException("Rule must be non-null");
        }
        this.boundaryRule = boundaryRule;
    }

    public boolean intersects(Coordinate p, Geometry geom) {
        return this.locate(p, geom) != 2;
    }

    public int locate(Coordinate p, Geometry geom) {
        if (geom.isEmpty()) {
            return 2;
        }
        if (geom instanceof LineString) {
            return this.locate(p, (LineString)geom);
        }
        if (geom instanceof Polygon) {
            return this.locate(p, (Polygon)geom);
        }
        this.isIn = false;
        this.numBoundaries = 0;
        this.computeLocation(p, geom);
        if (this.boundaryRule.isInBoundary(this.numBoundaries)) {
            return 1;
        }
        if (this.numBoundaries > 0 || this.isIn) {
            return 0;
        }
        return 2;
    }

    private void computeLocation(Coordinate p, Geometry geom) {
        block4: {
            block7: {
                block6: {
                    block5: {
                        block3: {
                            if (!(geom instanceof LineString)) break block3;
                            this.updateLocationInfo(this.locate(p, (LineString)geom));
                            break block4;
                        }
                        if (!(geom instanceof Polygon)) break block5;
                        this.updateLocationInfo(this.locate(p, (Polygon)geom));
                        break block4;
                    }
                    if (!(geom instanceof MultiLineString)) break block6;
                    MultiLineString ml = (MultiLineString)geom;
                    for (int i = 0; i < ml.getNumGeometries(); ++i) {
                        LineString l = (LineString)ml.getGeometryN(i);
                        this.updateLocationInfo(this.locate(p, l));
                    }
                    break block4;
                }
                if (!(geom instanceof MultiPolygon)) break block7;
                MultiPolygon mpoly = (MultiPolygon)geom;
                for (int i = 0; i < mpoly.getNumGeometries(); ++i) {
                    Polygon poly = (Polygon)mpoly.getGeometryN(i);
                    this.updateLocationInfo(this.locate(p, poly));
                }
                break block4;
            }
            if (!(geom instanceof GeometryCollection)) break block4;
            GeometryCollectionIterator geomi = new GeometryCollectionIterator((GeometryCollection)geom);
            while (geomi.hasNext()) {
                Geometry g2 = (Geometry)geomi.next();
                if (g2 == geom) continue;
                this.computeLocation(p, g2);
            }
        }
    }

    private void updateLocationInfo(int loc) {
        if (loc == 0) {
            this.isIn = true;
        }
        if (loc == 1) {
            ++this.numBoundaries;
        }
    }

    private int locate(Coordinate p, LineString l) {
        Coordinate[] pt = l.getCoordinates();
        if (!l.isClosed() && (p.equals(pt[0]) || p.equals(pt[pt.length - 1]))) {
            return 1;
        }
        if (CGAlgorithms.isOnLine(p, pt)) {
            return 0;
        }
        return 2;
    }

    private int locateInPolygonRing(Coordinate p, LinearRing ring) {
        if (CGAlgorithms.isOnLine(p, ring.getCoordinates())) {
            return 1;
        }
        if (CGAlgorithms.isPointInRing(p, ring.getCoordinates())) {
            return 0;
        }
        return 2;
    }

    private int locate(Coordinate p, Polygon poly) {
        if (poly.isEmpty()) {
            return 2;
        }
        LinearRing shell = (LinearRing)poly.getExteriorRing();
        int shellLoc = this.locateInPolygonRing(p, shell);
        if (shellLoc == 2) {
            return 2;
        }
        if (shellLoc == 1) {
            return 1;
        }
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            LinearRing hole = (LinearRing)poly.getInteriorRingN(i);
            int holeLoc = this.locateInPolygonRing(p, hole);
            if (holeLoc == 0) {
                return 2;
            }
            if (holeLoc != 1) continue;
            return 1;
        }
        return 0;
    }
}

