/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.gdalframework;

import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class GDALCommonIIOStreamMetadata
extends IIOMetadata {
    public static final String nativeMetadataFormatName = "it.geosolutions.imageio.gdalframework.commonStreamMetadata_1.0";
    public static final String nativeMetadataFormatClassName = "it.geosolutions.imageio.gdalframework.GDALCommonIIOStreamMetadata";
    private final String[] datasetNames;

    public GDALCommonIIOStreamMetadata(String[] datasetNames) {
        super(false, nativeMetadataFormatName, nativeMetadataFormatClassName, null, null);
        this.datasetNames = datasetNames;
    }

    public Node getAsTree(String formatName) {
        if (!nativeMetadataFormatName.equalsIgnoreCase(formatName)) {
            throw new IllegalArgumentException(formatName + " is not a recognized format name for gdal stream metadata.");
        }
        IIOMetadataNode root = new IIOMetadataNode(nativeMetadataFormatName);
        IIOMetadataNode dataSetsNode = new IIOMetadataNode("DataSets");
        root.appendChild(dataSetsNode);
        int length = this.datasetNames.length;
        if (length > 1) {
            --length;
        }
        dataSetsNode.setAttribute("number", Integer.toString(length));
        for (int i = 0; i < length; ++i) {
            IIOMetadataNode dataSetNode = new IIOMetadataNode("DataSet");
            dataSetNode.setAttribute("name", this.datasetNames[i]);
            dataSetsNode.appendChild(dataSetNode);
        }
        return root;
    }

    public boolean isReadOnly() {
        return true;
    }

    public void mergeTree(String formatName, Node root) throws IIOInvalidTreeException {
        throw new UnsupportedOperationException("mergeTree operation is not allowed");
    }

    public void reset() {
        throw new UnsupportedOperationException("reset operation is not allowed");
    }
}

