/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.gdalframework;

public class GDALCreateOption {
    private String optionName;
    private int representedValueType;
    public static final int TYPE_INT = 50;
    public static final int TYPE_FLOAT = 51;
    public static final int TYPE_NONE = 55;
    public static final int TYPE_CHAR = 58;
    public static final int TYPE_STRING = 59;
    private int validityCheckType;
    public static final int VALIDITYCHECKTYPE_VALUE = 0;
    public static final int VALIDITYCHECKTYPE_ONEOF = 1;
    public static final int VALIDITYCHECKTYPE_COMBINATIONOF = 2;
    public static final int VALIDITYCHECKTYPE_VALUE_BELONGINGRANGE_EXTREMESINCLUDED = 10;
    public static final int VALIDITYCHECKTYPE_VALUE_BELONGINGRANGE_LEFTEXCLUDED = 11;
    public static final int VALIDITYCHECKTYPE_VALUE_BELONGINGRANGE_RIGHTEXCLUDED = 12;
    public static final int VALIDITYCHECKTYPE_VALUE_BELONGINGRANGE_EXTREMESEXCLUDED = 19;
    public static final int VALIDITYCHECKTYPE_VALUE_LESSTHAN = 21;
    public static final int VALIDITYCHECKTYPE_VALUE_LESSTHANOREQUALTO = 22;
    public static final int VALIDITYCHECKTYPE_VALUE_GREATERTHANOREQUALTO = 23;
    public static final int VALIDITYCHECKTYPE_VALUE_GREATERTHAN = 24;
    public static final int VALIDITYCHECKTYPE_VALUE_MULTIPLEOF = 25;
    public static final int VALIDITYCHECKTYPE_VALUE_POWEROF = 26;
    public static final int VALIDITYCHECKTYPE_STRING_SYNTAX = 100;
    public static final int VALIDITYCHECKTYPE_NONE = 9999;
    private String[] validityValues;
    private boolean set;
    private String value;
    private String defaultValue;

    public GDALCreateOption(String optionName, int validityCheckType, String[] validityValues, int representedValueType) {
        this.optionName = optionName;
        this.validityCheckType = validityCheckType;
        this.validityValues = validityValues;
        this.representedValueType = representedValueType;
        this.value = "";
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getOptionName() {
        return this.optionName;
    }

    public void setOptionName(String optionName) {
        this.optionName = optionName;
    }

    public boolean isSet() {
        return this.set;
    }

    public int getValidityCheckType() {
        return this.validityCheckType;
    }

    public void setValidityCheckType(int validityType) {
        this.validityCheckType = validityType;
    }

    public String[] getValidityValues() {
        return this.validityValues;
    }

    public void setValidityValues(String[] validityValues) {
        this.validityValues = validityValues;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        if (!this.checkValidity(value)) {
            StringBuffer sb = new StringBuffer("Error while setting value for create option ''").append(this.optionName).append("''");
            throw new IllegalArgumentException(sb.toString());
        }
        this.value = value;
        this.set = true;
    }

    private boolean checkValidity(String checkingValue) {
        switch (this.validityCheckType) {
            case 9999: {
                return true;
            }
            case 0: {
                return this.checkValueIs(checkingValue);
            }
            case 1: {
                return this.checkOneOf(checkingValue);
            }
            case 2: {
                return this.checkCombinationOf(checkingValue);
            }
            case 10: 
            case 11: 
            case 12: 
            case 19: {
                switch (this.representedValueType) {
                    case 50: {
                        return this.checkIntRange(checkingValue);
                    }
                    case 51: {
                        return this.checkFloatRange(checkingValue);
                    }
                }
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                switch (this.representedValueType) {
                    case 50: {
                        return this.checkIntValue(checkingValue);
                    }
                    case 51: {
                        return this.checkFloatValue(checkingValue);
                    }
                }
                break;
            }
            case 100: {
                return this.checkStringSyntaxCompliance(checkingValue);
            }
        }
        return false;
    }

    private boolean checkValueIs(String checkingValue) {
        return checkingValue.equals(this.validityValues[0]);
    }

    private boolean checkStringSyntaxCompliance(String checkingValue) {
        int i;
        int expectedTokensNumber = this.validityValues[0].length();
        char[] token = this.validityValues[0].toCharArray();
        int checkingStringLength = checkingValue.length();
        int[] tokenPoisitions = new int[expectedTokensNumber];
        int tokenPosition = -1;
        int tokensFound = 0;
        for (i = 0; i < expectedTokensNumber && (tokenPosition = checkingValue.indexOf(token[i], tokenPosition + 1)) != -1; ++i) {
            ++tokensFound;
            tokenPoisitions[i] = tokenPosition;
        }
        if (tokensFound < expectedTokensNumber) {
            return false;
        }
        for (i = 0; i < expectedTokensNumber - 1; ++i) {
            if (tokenPoisitions[i] != tokenPoisitions[i + 1] - 1) continue;
            return false;
        }
        return tokenPoisitions[expectedTokensNumber - 1] != checkingStringLength;
    }

    private boolean checkIntRange(String checkingValue) {
        int sx = Integer.parseInt(this.validityValues[0]);
        int dx = Integer.parseInt(this.validityValues[1]);
        int parsedValue = Integer.parseInt(checkingValue);
        switch (this.validityCheckType) {
            case 10: {
                if (parsedValue < sx || parsedValue > dx) break;
                return true;
            }
            case 11: {
                if (parsedValue <= sx || parsedValue > dx) break;
                return true;
            }
            case 12: {
                if (parsedValue < sx || parsedValue >= dx) break;
                return true;
            }
            case 19: {
                if (parsedValue <= sx || parsedValue >= dx) break;
                return true;
            }
        }
        return false;
    }

    private boolean checkIntValue(String checkingValue) {
        int reference = Integer.parseInt(this.validityValues[0]);
        int parsedValue = Integer.parseInt(checkingValue);
        switch (this.validityCheckType) {
            case 22: {
                if (parsedValue > reference) break;
                return true;
            }
            case 21: {
                if (parsedValue >= reference) break;
                return true;
            }
            case 23: {
                if (parsedValue < reference) break;
                return true;
            }
            case 24: {
                if (parsedValue <= reference) break;
                return true;
            }
            case 26: {
                int result = 1;
                while (result < Integer.MAX_VALUE) {
                    if ((result *= reference) != parsedValue) continue;
                    return true;
                }
                break;
            }
            case 25: {
                if (parsedValue % reference != 0) break;
                return true;
            }
        }
        return false;
    }

    private boolean checkFloatRange(String checkingValue) {
        float sx = Float.parseFloat(this.validityValues[0]);
        float dx = Float.parseFloat(this.validityValues[1]);
        float parsedValue = Float.parseFloat(checkingValue);
        switch (this.validityCheckType) {
            case 10: {
                if (!(parsedValue >= sx) || !(parsedValue <= dx)) break;
                return true;
            }
            case 11: {
                if (!(parsedValue > sx) || !(parsedValue <= dx)) break;
                return true;
            }
            case 12: {
                if (!(parsedValue >= sx) || !(parsedValue < dx)) break;
                return true;
            }
            case 19: {
                if (!(parsedValue > sx) || !(parsedValue < dx)) break;
                return true;
            }
        }
        return false;
    }

    private boolean checkFloatValue(String checkingValue) {
        float reference = Float.parseFloat(this.validityValues[0]);
        float parsedValue = Float.parseFloat(checkingValue);
        switch (this.validityCheckType) {
            case 22: {
                if (!(parsedValue <= reference)) break;
                return true;
            }
            case 21: {
                if (!(parsedValue < reference)) break;
                return true;
            }
            case 23: {
                if (!(parsedValue >= reference)) break;
                return true;
            }
            case 24: {
                if (!(parsedValue > reference)) break;
                return true;
            }
            case 25: {
                if (parsedValue % reference != 0.0f) break;
                return true;
            }
        }
        return false;
    }

    private boolean checkOneOf(String checkingValue) {
        int cases = this.validityValues.length;
        for (int i = 0; i < cases; ++i) {
            if (!checkingValue.equals(this.validityValues[i])) continue;
            return true;
        }
        return false;
    }

    private boolean checkCombinationOf(String checkingValues) {
        int numOfValidityValues = this.validityValues.length;
        String[] values = checkingValues.split("\\|");
        int numSpecifiedValues = values.length;
        for (int l = 0; l < numSpecifiedValues; ++l) {
            String comparingString = values[l];
            for (int k = l + 1; k < numSpecifiedValues; ++k) {
                if (!values[k].equals(comparingString)) continue;
                return false;
            }
        }
        for (int i = 0; i < numSpecifiedValues; ++i) {
            boolean supported = false;
            for (int j = 0; j < numOfValidityValues; ++j) {
                if (!values[i].equals(this.validityValues[j])) continue;
                supported = true;
                break;
            }
            if (supported) continue;
            return false;
        }
        return true;
    }

    public int getRepresentedValueType() {
        return this.representedValueType;
    }

    public void setRepresentedValueType(int representedValueType) {
        this.representedValueType = representedValueType;
    }
}

