/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.gdalframework;

import it.geosolutions.imageio.gdalframework.GDALUtilities;
import it.geosolutions.imageio.stream.input.FileImageInputStreamExt;
import it.geosolutions.imageio.stream.input.FileImageInputStreamExtImpl;
import it.geosolutions.imageio.stream.input.spi.StringImageInputStreamSpi;
import it.geosolutions.imageio.stream.input.spi.URLImageInputStreamSpi;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;
import org.gdal.gdal.Dataset;
import org.gdal.gdal.Driver;
import org.gdal.gdalconst.gdalconst;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GDALImageReaderSpi
extends ImageReaderSpi {
    private static final Logger LOGGER = Logger.getLogger(GDALImageReaderSpi.class.toString());
    private static final StringImageInputStreamSpi stringSPI;
    private static final URLImageInputStreamSpi URLSPI;
    private List<String> supportedFormats;

    public List<String> getSupportedFormats() {
        return Collections.unmodifiableList(this.supportedFormats);
    }

    public GDALImageReaderSpi(String vendorName, String version, String[] names, String[] suffixes, String[] MIMETypes, String readerClassName, Class<?>[] inputTypes, String[] writerSpiNames, boolean supportsStandardStreamMetadataFormat, String nativeStreamMetadataFormatName, String nativeStreamMetadataFormatClassName, String[] extraStreamMetadataFormatNames, String[] extraStreamMetadataFormatClassNames, boolean supportsStandardImageMetadataFormat, String nativeImageMetadataFormatName, String nativeImageMetadataFormatClassName, String[] extraImageMetadataFormatNames, String[] extraImageMetadataFormatClassNames, Collection<String> supportedFormats) {
        super(vendorName, version, names, suffixes, MIMETypes, readerClassName, inputTypes, writerSpiNames, supportsStandardStreamMetadataFormat, nativeStreamMetadataFormatName, nativeStreamMetadataFormatClassName, extraStreamMetadataFormatNames, extraStreamMetadataFormatClassNames, supportsStandardImageMetadataFormat, nativeImageMetadataFormatName, nativeImageMetadataFormatClassName, extraImageMetadataFormatNames, extraImageMetadataFormatClassNames);
        this.supportedFormats = new ArrayList<String>(supportedFormats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canDecodeInput(Object input) throws IOException {
        if (input == null) {
            return false;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Can Decode Input called with object " + input.toString());
        }
        if (input instanceof String) {
            try {
                input = stringSPI.createInputStreamInstance(input, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
            }
            catch (Throwable e) {
                if (!LOGGER.isLoggable(Level.FINE)) return false;
                LOGGER.log(Level.FINE, "Input filed does not exist or cannot be read", e);
                return false;
            }
        }
        if (input instanceof URL) {
            try {
                input = URLSPI.createInputStreamInstance(input, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
            }
            catch (Throwable e) {
                if (!LOGGER.isLoggable(Level.FINE)) return false;
                LOGGER.log(Level.FINE, "Input filed does not exist or cannot be read", e);
                return false;
            }
        }
        if (input instanceof File) {
            try {
                input = new FileImageInputStreamExtImpl((File)input);
            }
            catch (Throwable e) {
                if (!LOGGER.isLoggable(Level.FINE)) return false;
                LOGGER.log(Level.FINE, "Input filed does not exist or cannot be read", e);
                return false;
            }
        }
        assert (input instanceof ImageInputStream);
        if (!(input instanceof FileImageInputStreamExt)) {
            return false;
        }
        FileImageInputStreamExt stream = (FileImageInputStreamExt)input;
        boolean isInputDecodable = false;
        Dataset ds = null;
        String s = stream.getFile().getAbsolutePath();
        ds = GDALUtilities.acquireDataSet(s, gdalconst.GA_ReadOnly);
        isInputDecodable = this.isDecodable(ds);
        if (ds == null) return isInputDecodable;
        try {
            GDALUtilities.closeDataSet(ds);
            return isInputDecodable;
        }
        catch (Throwable e) {
            if (!LOGGER.isLoggable(Level.FINEST)) return isInputDecodable;
            LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
        }
        return isInputDecodable;
        catch (Throwable e) {
            try {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
                if (ds == null) return isInputDecodable;
            }
            catch (Throwable throwable) {
                if (ds == null) throw throwable;
                try {
                    GDALUtilities.closeDataSet(ds);
                    throw throwable;
                }
                catch (Throwable e2) {
                    if (!LOGGER.isLoggable(Level.FINEST)) throw throwable;
                    LOGGER.log(Level.FINEST, e2.getLocalizedMessage(), e2);
                }
                throw throwable;
            }
            try {
                GDALUtilities.closeDataSet(ds);
                return isInputDecodable;
            }
            catch (Throwable e3) {
                if (!LOGGER.isLoggable(Level.FINEST)) return isInputDecodable;
                LOGGER.log(Level.FINEST, e3.getLocalizedMessage(), e3);
            }
            return isInputDecodable;
        }
    }

    protected boolean isDecodable(Dataset dataset) {
        if (dataset != null) {
            Driver driver = dataset.GetDriver();
            String sDriver = driver.getShortName();
            return this.getSupportedFormats().contains(sDriver);
        }
        return false;
    }

    public boolean isAvailable() {
        if (!GDALUtilities.isGDALAvailable()) {
            return false;
        }
        List<String> supportedFormats = this.getSupportedFormats();
        Iterator<String> it = supportedFormats.iterator();
        if (!it.hasNext()) {
            return false;
        }
        while (it.hasNext()) {
            String formatName = it.next();
            if (GDALUtilities.isDriverAvailable(formatName)) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized void onRegistration(ServiceRegistry registry, Class<?> category) {
        super.onRegistration(registry, category);
        if (!GDALUtilities.isGDALAvailable()) {
            IIORegistry iioRegistry = (IIORegistry)registry;
            Class<ImageReaderSpi> spiClass = ImageReaderSpi.class;
            Iterator<ImageReaderSpi> iter = iioRegistry.getServiceProviders(spiClass, true);
            while (iter.hasNext()) {
                ImageReaderSpi provider = iter.next();
                if (!(provider instanceof GDALImageReaderSpi)) continue;
                registry.deregisterServiceProvider(provider);
            }
        }
    }

    static {
        GDALUtilities.loadGDAL();
        stringSPI = new StringImageInputStreamSpi();
        URLSPI = new URLImageInputStreamSpi();
    }
}

