/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.DataInputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;

public class McastSenderTest {
    public static void main(String[] args) {
        InetAddress mcast_addr = null;
        InetAddress bind_addr = null;
        byte[] buf = new byte[]{};
        int ttl = 32;
        AckReceiver ack_receiver = null;
        int port = 5555;
        try {
            for (int i = 0; i < args.length; ++i) {
                String tmp = args[i];
                if ("-help".equals(tmp)) {
                    McastSenderTest.help();
                    return;
                }
                if ("-bind_addr".equals(tmp)) {
                    bind_addr = InetAddress.getByName(args[++i]);
                    continue;
                }
                if ("-mcast_addr".equals(tmp)) {
                    mcast_addr = InetAddress.getByName(args[++i]);
                    continue;
                }
                if ("-ttl".equals(tmp)) {
                    ttl = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-port".equals(tmp)) {
                    port = Integer.parseInt(args[++i]);
                    continue;
                }
                McastSenderTest.help();
                return;
            }
            if (mcast_addr == null) {
                mcast_addr = InetAddress.getByName("224.0.0.150");
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
            return;
        }
        try {
            MulticastSocket sock = new MulticastSocket(port);
            sock.setTimeToLive(ttl);
            if (bind_addr != null) {
                sock.setInterface(bind_addr);
            }
            System.out.println("Socket=" + sock.getLocalAddress() + ':' + sock.getLocalPort() + ", ttl=" + sock.getTimeToLive() + ", bind interface=" + sock.getInterface());
            ack_receiver = new AckReceiver(sock);
            ack_receiver.start();
            DataInputStream in = new DataInputStream(System.in);
            while (true) {
                System.out.print("> ");
                String line = in.readLine();
                if (line.startsWith("quit") || line.startsWith("exit")) {
                    if (ack_receiver != null) {
                        ack_receiver.stop();
                    }
                    break;
                }
                buf = line.getBytes();
                DatagramPacket packet = new DatagramPacket(buf, buf.length, mcast_addr, port);
                sock.send(packet);
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    static void help() {
        System.out.println("McastSenderTest [-bind_addr <bind address>] [-help] [-mcast_addr <multicast address>] [-port <multicast port that receivers are listening on>] [-ttl <time to live for mcast packets>]");
    }

    private static class AckReceiver
    implements Runnable {
        DatagramSocket sock;
        DatagramPacket packet;
        byte[] buf;
        Thread t = null;

        AckReceiver(DatagramSocket sock) {
            this.sock = sock;
        }

        public void run() {
            while (this.t != null) {
                try {
                    this.buf = new byte[256];
                    this.packet = new DatagramPacket(this.buf, this.buf.length);
                    this.sock.receive(this.packet);
                    System.out.println("<< Received response from " + this.packet.getAddress().getHostAddress() + ':' + this.packet.getPort() + ": " + new String(this.packet.getData()));
                }
                catch (Exception e) {
                    System.err.println(e);
                    break;
                }
            }
            this.t = null;
        }

        void start() {
            this.t = new Thread((Runnable)this, "McastSenderTest.AckReceiver thread");
            this.t.start();
        }

        void stop() {
            if (this.t != null && this.t.isAlive()) {
                this.t = null;
                try {
                    this.sock.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

