/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.ChannelException;
import org.jgroups.Message;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.PingHeader;
import org.jgroups.protocols.PingRsp;
import org.jgroups.protocols.UdpHeader;
import org.jgroups.protocols.WanPipeAddress;
import org.jgroups.stack.IpAddress;

public class StreamableTest
extends TestCase {
    Message m1;
    Message m2;

    public StreamableTest(String name) {
        super(name);
    }

    public void testStreamable() throws Exception {
        byte[] buf = new byte[]{98, 101, 108, 97, 98, 97, 110};
        this.m1 = new Message(null, null, buf, 0, 4);
        this.m2 = new Message(null, null, buf, 4, 3);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(output);
        this.m1.writeTo(out);
        out.close();
        byte[] tmp = output.toByteArray();
        output.close();
        ByteArrayInputStream input = new ByteArrayInputStream(tmp);
        DataInputStream in = new DataInputStream(input);
        Message m3 = new Message();
        m3.readFrom(in);
        StreamableTest.assertEquals((int)4, (int)m3.getLength());
        StreamableTest.assertEquals((int)4, (int)m3.getRawBuffer().length);
        StreamableTest.assertEquals((int)4, (int)m3.getBuffer().length);
        StreamableTest.assertEquals((int)0, (int)m3.getOffset());
        output = new ByteArrayOutputStream();
        out = new DataOutputStream(output);
        this.m2.writeTo(out);
        out.close();
        tmp = output.toByteArray();
        output.close();
        System.out.println("-- serialized buffer is " + tmp.length + " bytes");
        input = new ByteArrayInputStream(tmp);
        in = new DataInputStream(input);
        Message m4 = new Message();
        m4.readFrom(in);
        StreamableTest.assertEquals((int)3, (int)m4.getLength());
        StreamableTest.assertEquals((int)3, (int)m4.getBuffer().length);
        StreamableTest.assertEquals((int)3, (int)m4.getRawBuffer().length);
        StreamableTest.assertEquals((int)0, (int)m4.getOffset());
    }

    public void testStreamable2() throws Exception {
        byte[] buf = new byte[]{98, 101, 108, 97, 98, 97, 110};
        Message msg = new Message(null, null, buf, 0, 4);
        this.stream(msg);
    }

    public void testStreamable3() throws Exception {
        byte[] buf = new byte[]{98, 101, 108, 97, 98, 97, 110};
        Message msg = new Message(null, null, buf, 4, 3);
        this.stream(msg);
    }

    public void testNullBuffer() throws Exception {
        Message msg = new Message();
        this.stream(msg);
    }

    public void testNonNullBuffer() throws Exception {
        Message msg = new Message(null, null, "Hello world".getBytes());
        this.stream(msg);
    }

    public void testNonNullAddress() throws Exception {
        IpAddress dest = new IpAddress("228.1.2.3", 5555);
        IpAddress src = new IpAddress("127.0.0.1", 6666);
        Message msg = new Message((Address)dest, (Address)src, "Hello world".getBytes());
        this.stream(msg);
    }

    public void testHeaders() throws Exception {
        IpAddress dest = new IpAddress("228.1.2.3", 5555);
        IpAddress src = new IpAddress("127.0.0.1", 6666);
        Message msg = new Message((Address)dest, (Address)src, "Hello world".getBytes());
        PingHeader hdr = new PingHeader(1, new PingRsp(src, src, true));
        msg.putHeader("ping-header", hdr);
        UdpHeader udp_hdr = new UdpHeader("bla");
        msg.putHeader("udp-header", udp_hdr);
        this.stream(msg);
    }

    public void testAdditionalData() throws Exception {
        IpAddress dest = new IpAddress("228.1.2.3", 5555);
        dest.setAdditionalData("foo".getBytes());
        IpAddress src = new IpAddress("127.0.0.1", 6666);
        src.setAdditionalData("foobar".getBytes());
        Message msg = new Message((Address)dest, (Address)src, "Hello world".getBytes());
        PingHeader hdr = new PingHeader(1, new PingRsp(src, src, false));
        msg.putHeader("ping-header", hdr);
        UdpHeader udp_hdr = new UdpHeader("bla");
        msg.putHeader("udp-header", udp_hdr);
        this.stream(msg);
    }

    public void testDifferentAddress() throws Exception {
        WanPipeAddress dest = new WanPipeAddress("foo");
        WanPipeAddress src = new WanPipeAddress("foobar");
        Message msg = new Message((Address)dest, (Address)src, "Hello world".getBytes());
        PingHeader hdr = new PingHeader(1, new PingRsp(src, src, false));
        msg.putHeader("ping-header", hdr);
        UdpHeader udp_hdr = new UdpHeader("bla");
        msg.putHeader("udp-header", udp_hdr);
        this.stream(msg);
    }

    private void stream(Message msg) throws Exception {
        int num_headers = this.getNumHeaders(msg);
        int length = msg.getLength();
        int bufLength = this.getBufLength(msg);
        Address dest = msg.getDest();
        Address src = msg.getSrc();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(output);
        msg.writeTo(out);
        out.close();
        byte[] tmp = output.toByteArray();
        output.close();
        System.out.println("-- serialized buffer is " + tmp.length + " bytes");
        ByteArrayInputStream input = new ByteArrayInputStream(tmp);
        DataInputStream in = new DataInputStream(input);
        Message msg2 = new Message();
        msg2.readFrom(in);
        StreamableTest.assertEquals((int)length, (int)msg2.getLength());
        StreamableTest.assertEquals((int)bufLength, (int)this.getBufLength(msg2));
        StreamableTest.assertTrue((boolean)this.match(dest, msg2.getDest()));
        StreamableTest.assertTrue((boolean)this.match(src, msg2.getSrc()));
        StreamableTest.assertEquals((int)num_headers, (int)this.getNumHeaders(msg2));
    }

    private int getNumHeaders(Message msg) {
        return msg.getHeaders() != null ? msg.getHeaders().size() : 0;
    }

    private boolean match(Address a1, Address a2) {
        if (a1 == null && a2 == null) {
            return true;
        }
        if (a1 != null) {
            return a1.equals(a2);
        }
        return a2.equals(a1);
    }

    private int getBufLength(Message msg) {
        return msg.getBuffer() != null ? msg.getBuffer().length : 0;
    }

    public static Test suite() {
        TestSuite s = new TestSuite(StreamableTest.class);
        return s;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)StreamableTest.suite());
    }

    static {
        try {
            ClassConfigurator.getInstance(true);
        }
        catch (ChannelException e) {
            e.printStackTrace();
        }
    }
}

