/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.ajax;

import java.util.List;
import java.util.Map;
import net.sf.tacos.ajax.AjaxDirectService;
import net.sf.tacos.ajax.AjaxInvocation;
import net.sf.tacos.ajax.AjaxWebRequest;
import net.sf.tacos.util.EffectStringUtils;
import net.sf.tacos.util.ScriptUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IScript;
import org.apache.tapestry.IScriptProcessor;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.services.ExpressionEvaluator;

public class AjaxUtils {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$net$sf$tacos$ajax$DeferredScriptProducer;

    public static final boolean isAjaxRequest(AjaxDirectService service) {
        AjaxWebRequest ar = service.getAjaxRequest();
        return ar != null && ar.isValidRequest();
    }

    public static boolean isAjaxCycle(IRequestCycle cycle) {
        AjaxWebRequest request = (AjaxWebRequest)cycle.getAttribute("ajax-request");
        return request != null && request.isValidRequest();
    }

    public static void putAjaxParameter(AjaxInvocation ajaxInvocation, Map parameters, IRequestCycle cycle) {
        String reqUrl = ajaxInvocation.getAjaxLink().getAbsoluteURL();
        parameters.put("url", reqUrl);
        parameters.put("evalScripts", Boolean.TRUE);
        parameters.put("ajax", AjaxUtils.isAjaxRequest(ajaxInvocation.getAjaxEngine()));
        if (ajaxInvocation.getUpdateObject() != null) {
            parameters.put("updateObject", ajaxInvocation.getUpdateObject());
        } else {
            parameters.put("updateObject", "null");
        }
        if (ajaxInvocation.getEffects() != null) {
            parameters.put("effects", ScriptUtils.escapeJavaScriptHash(ajaxInvocation.getEffects()));
        } else {
            parameters.put("effects", "{}");
        }
        if (ajaxInvocation.getPreEffects() != null) {
            parameters.put("preEffects", EffectStringUtils.createPreEffectsScript(ajaxInvocation.getPreEffects(), ajaxInvocation.getUpdateComponents()));
        }
        if (ajaxInvocation.getPopup() != null) {
            parameters.put("popup", ScriptUtils.escapeJavaScriptHash(ajaxInvocation.getPopup()));
        }
        if (ajaxInvocation.getBackLink() != null) {
            parameters.put("backLink", AjaxUtils.getLinkString(ajaxInvocation.getBackLink(), true));
        }
        if (ajaxInvocation.getForwardLink() != null) {
            parameters.put("forwardLink", AjaxUtils.getLinkString(ajaxInvocation.getForwardLink(), true));
        }
        if (ajaxInvocation.getStatusElement() != null) {
            parameters.put("statusElement", ajaxInvocation.getStatusElement());
        }
        if ("multipart/form-data".equals(ajaxInvocation.getEncodingType())) {
            parameters.put("multipart", Boolean.TRUE);
        }
    }

    public static void linkFieldObservers(IRequestCycle cycle, ExpressionEvaluator eval, AjaxWebRequest ajaxr, IComponent comp, PageRenderSupport prs, String eventListener) {
        AjaxUtils.linkFieldObservers(cycle, eval, ajaxr, comp, null, prs, eventListener);
    }

    public static void linkFieldObservers(IRequestCycle cycle, ExpressionEvaluator eval, AjaxWebRequest ajaxr, IComponent comp, String uniqueId, PageRenderSupport prs, String eventListener) {
        Defense.notNull((Object)eventListener, (String)"eventListener string can't be null.");
        Defense.notNull((Object)eval, (String)"ExpressionEvaluator");
        Defense.notNull((Object)comp, (String)"IFormComponent");
        String fieldId = ScriptUtils.getFieldId(comp, uniqueId);
        Defense.notNull((Object)fieldId, (String)"clientId");
        boolean ajax = ajaxr.isValidRequest();
        IComponent container = ScriptUtils.getContainer(comp);
        eventListener = StringUtils.deleteWhitespace((String)eventListener);
        String[] strParams = StringUtils.split((String)eventListener, (char)',');
        for (int i = 0; i < strParams.length; ++i) {
            String strParam = strParams[i];
            String event = strParam.substring(0, strParam.indexOf("="));
            String value = strParam.substring(strParam.indexOf("=") + 1, strParam.length());
            Object evald = eval.read((Object)container, value);
            String eventSubmitId = null;
            if (evald != null && evald.getClass().isAssignableFrom(class$java$lang$String == null ? AjaxUtils.class$("java.lang.String") : class$java$lang$String)) {
                eventSubmitId = (String)evald;
            } else if (evald != null && (class$net$sf$tacos$ajax$DeferredScriptProducer == null ? AjaxUtils.class$("net.sf.tacos.ajax.DeferredScriptProducer") : class$net$sf$tacos$ajax$DeferredScriptProducer).isInstance(evald)) {
                eventSubmitId = ((IComponent)evald).getId();
            }
            if (event == null) {
                throw new ApplicationRuntimeException("Event parameter for eventListener attribute was found to be null in string:" + eventListener);
            }
            if (value == null) {
                throw new ApplicationRuntimeException("Observer id parameter for eventListener attribute was found to be null in string:" + eventListener);
            }
            if (eventSubmitId == null) {
                throw new ApplicationRuntimeException("Observer parameter for eventListener attribute was found but couldn't be evaluated to a valid property, make sure it specifies the observer in the form of components.<your AjaxEventSubmitName>.id or components.<your AjaxEventSubmitComponent> String input was:" + eventListener);
            }
            List scripts = ajaxr.getDeferredScripts(eventSubmitId);
            if (scripts == null) {
                throw new ApplicationRuntimeException("Observer specified in fields eventListener parameter was found but no deferred scripts were available. String input was:" + eventListener + " " + "with observer id:" + eventSubmitId);
            }
            for (int j = 0; j < scripts.size(); ++j) {
                Map parms = (Map)scripts.get(j);
                IScript script = (IScript)parms.get("script");
                Map sparms = (Map)parms.get("parms");
                sparms.put("listenFieldId", fieldId);
                sparms.put("eventName", event);
                sparms.put("ajax", ajax);
                script.execute(cycle, (IScriptProcessor)prs, sparms);
            }
        }
    }

    public static String getLinkArguments(AjaxInvocation invocation, boolean globalScope) {
        ILink link = invocation.getAjaxLink();
        StringBuffer str = new StringBuffer("{");
        str.append("targetLink: this, ");
        if (invocation.getUpdateObject() != null) {
            str.append("updateObject: ").append(invocation.getUpdateObject()).append(",");
        }
        if (globalScope) {
            str.append("url: '").append(link.getURL()).append("', ");
        } else {
            str.append("url: this.href, ");
        }
        str.append("processScripts: ").append(true);
        if (invocation.getEffects() != null) {
            str.append(", effects: ").append(ScriptUtils.escapeJavaScriptHash(invocation.getEffects()));
        }
        if (invocation.getPopup() != null) {
            str.append(", popup: ").append(ScriptUtils.escapeJavaScriptHash(invocation.getPopup()));
        }
        if (invocation.getStatusElement() != null) {
            str.append(", statusElement: '").append(invocation.getStatusElement()).append("'");
        }
        return str.append("}").toString();
    }

    public static String getLinkString(AjaxInvocation invocation, boolean globalScope) {
        return "tacos.defaultLinkAction(" + AjaxUtils.getLinkArguments(invocation, globalScope) + ")";
    }

    public static String createOnclickHandler(AjaxInvocation invocation, boolean globalScope) {
        return EffectStringUtils.createPreEffectsScript(invocation.getPreEffects(), invocation.getUpdateComponents()) + "return " + AjaxUtils.getLinkString(invocation, globalScope);
    }
}

