/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.ajax.components;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sf.tacos.ajax.AjaxDirectServiceParameter;
import net.sf.tacos.ajax.AjaxSubmitInvocation;
import net.sf.tacos.ajax.AjaxUtils;
import net.sf.tacos.ajax.AjaxWebRequest;
import net.sf.tacos.ajax.components.AjaxForm;
import org.apache.tapestry.IActionListener;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IDirect;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.form.AbstractFormComponent;
import org.apache.tapestry.listener.ListenerInvoker;

public abstract class AbstractSubmit
extends AbstractFormComponent
implements AjaxSubmitInvocation {
    public abstract String getFocusElement();

    protected abstract boolean isClicked(IRequestCycle var1, String var2);

    protected void rewindFormComponent(IMarkupWriter writer, IRequestCycle cycle) {
        if (this.isClicked(cycle, this.getName())) {
            this.handleClick(cycle, this.getForm());
            String focusElement = this.getFocusElement();
            if (focusElement != null) {
                AjaxWebRequest ar = this.getAjaxEngine().getAjaxRequest();
                ar.setFocusElement(focusElement);
            }
        }
    }

    protected void handleClick(final IRequestCycle cycle, IForm form) {
        if (this.isParameterBound("selected")) {
            this.setSelected(this.getTag());
        }
        IActionListener listener = this.getListener();
        final IActionListener action = this.getAction();
        if (listener == null && action == null) {
            return;
        }
        final ListenerInvoker listenerInvoker = this.getListenerInvoker();
        Object parameters = this.getParameters();
        if (parameters != null) {
            if (parameters instanceof Collection) {
                cycle.setListenerParameters(((Collection)parameters).toArray());
            } else {
                cycle.setListenerParameters(new Object[]{parameters});
            }
        }
        if (listener != null) {
            listenerInvoker.invokeListener(listener, (IComponent)this, cycle);
        }
        if (action != null) {
            Runnable notify = new Runnable(){

                public void run() {
                    listenerInvoker.invokeListener(action, (IComponent)AbstractSubmit.this, cycle);
                }
            };
            form.addDeferredRunnable(notify);
        }
    }

    public abstract IActionListener getListener();

    public abstract IActionListener getAction();

    public abstract Object getTag();

    public abstract void setSelected(Object var1);

    public abstract boolean getDefer();

    public abstract Object getParameters();

    public abstract ListenerInvoker getListenerInvoker();

    public Map constructScriptParameter(IRequestCycle cycle) {
        HashMap<String, Object> parmMap = new HashMap<String, Object>();
        parmMap.put("name", this.getName());
        parmMap.put("componentId", this.getComponentId());
        parmMap.put("form", this.getForm());
        parmMap.put("hiddenId", this.getHiddenId());
        parmMap.put("submitNormal", this.isSubmitNormal());
        parmMap.put("deferred", this.isDeferred());
        if (this.isClientSideValidationEnabled()) {
            parmMap.put("validateForm", Boolean.TRUE);
        }
        AjaxUtils.putAjaxParameter(this, parmMap, cycle);
        return parmMap;
    }

    public String getEncodingType() {
        boolean ajaxForm = AjaxForm.class.isInstance(this.getForm());
        if (ajaxForm) {
            return ((AjaxForm)this.getForm()).getEncodingType();
        }
        return null;
    }

    public ILink getAjaxLink() {
        String[] updateComponents = new String[]{};
        if (this.getUpdateComponents() != null) {
            updateComponents = this.getUpdateComponents().toArray(new String[this.getUpdateComponents().size()]);
        }
        AjaxDirectServiceParameter dsp = new AjaxDirectServiceParameter((IDirect)this.getForm(), new Object[0], updateComponents, false);
        return this.getAjaxEngine().getLink(true, (Object)dsp);
    }
}

