/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.ajax.components;

import java.util.HashMap;
import java.util.Iterator;
import net.sf.tacos.ajax.AjaxDirectService;
import net.sf.tacos.ajax.AjaxDirectServiceParameter;
import net.sf.tacos.ajax.AjaxWebRequest;
import net.sf.tacos.ajax.components.ListItemRenderer;
import net.sf.tacos.util.ScriptUtils;
import net.sf.tacos.util.SizeRestrictingIterator;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.IActionListener;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IDirect;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IScript;
import org.apache.tapestry.IScriptProcessor;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.coerce.ValueConverter;
import org.apache.tapestry.engine.NullWriter;
import org.apache.tapestry.form.AbstractFormComponent;
import org.apache.tapestry.form.TranslatedField;
import org.apache.tapestry.form.TranslatedFieldSupport;
import org.apache.tapestry.form.ValidatableField;
import org.apache.tapestry.form.ValidatableFieldSupport;
import org.apache.tapestry.link.DirectLink;
import org.apache.tapestry.listener.ListenerInvoker;
import org.apache.tapestry.valid.ValidatorException;

public abstract class Autocompleter
extends AbstractFormComponent
implements IDirect,
TranslatedField {
    private static final Log log = LogFactory.getLog((Class)Autocompleter.class);
    private static final String CLIENT_ARRAYS_KEY = Autocompleter.class.getName() + ".clientArraysKey";

    public abstract AjaxDirectService getAjaxEngine();

    public abstract ListenerInvoker getListenerInvoker();

    public abstract IScript getScript();

    public abstract ValueConverter getValueConverter();

    public abstract IActionListener getListener();

    public abstract Object getListSource();

    public abstract void setListSource(Object var1);

    public abstract ListItemRenderer getListItemRenderer();

    public abstract int getMaxResults();

    public abstract boolean isDirect();

    public abstract double getFrequency();

    public abstract String getAfterUpdateElement();

    public abstract Object getParameters();

    public abstract void setSearchTriggered(boolean var1);

    public abstract boolean isSearchTriggered();

    public abstract Object getValue();

    public abstract void setValue(Object var1);

    public abstract String getTemplateTag();

    public abstract String getOptions();

    public abstract boolean isClientOnly();

    public abstract ValidatableFieldSupport getValidatableFieldSupport();

    public abstract TranslatedFieldSupport getTranslatedFieldSupport();

    public boolean isRequired() {
        return this.getValidatableFieldSupport().isRequired((ValidatableField)this);
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        log.debug((Object)"renderComponent()");
        if (this.getAjaxEngine() != null && this.getAjaxEngine().getAjaxRequest() != null && this.getAjaxEngine().getAjaxRequest().isValidRequest() && this.isSearchTriggered()) {
            this.triggerClientIdGeneration(cycle);
            if (!this.getAjaxEngine().getAjaxRequest().containsComponentId(this.getClientId())) {
                return;
            }
            if (writer instanceof NullWriter) {
                writer = this.getAjaxEngine().getAjaxRequest().getResponseBuilder().getComponentWriter(this.getClientId());
            }
            this.renderList(writer, cycle);
            log.debug((Object)"renderComponent() rendered directly");
            return;
        }
        log.debug((Object)"renderComponent() calling super.render");
        super.renderComponent(writer, cycle);
    }

    protected void renderFormComponent(IMarkupWriter writer, IRequestCycle cycle) {
        log.debug((Object)("renderFormComponent() cycle rewinding?:" + cycle.isRewinding()));
        AjaxWebRequest ajax = (AjaxWebRequest)cycle.getAttribute("ajax-request");
        if (ajax != null && (!ajax.containsComponentId(this.getClientId()) || this.isSearchTriggered()) && writer instanceof NullWriter) {
            this.triggerClientIdGeneration(cycle);
            return;
        }
        boolean isTextarea = "textarea".equalsIgnoreCase(this.getTemplateTag());
        String value = this.getTranslatedFieldSupport().format((TranslatedField)this, this.getValue());
        boolean disabled = this.isDisabled();
        this.renderDelegatePrefix(writer, cycle);
        if (isTextarea) {
            writer.begin("textarea");
        } else {
            writer.beginEmpty("input");
            writer.attribute("type", "text");
            writer.attribute("autocomplete", "off");
            writer.attribute("value", value);
        }
        writer.attribute("name", this.getName());
        if (disabled) {
            writer.attribute("disabled", "disabled");
        }
        this.renderIdAttribute(writer, cycle);
        this.renderDelegateAttributes(writer, cycle);
        this.getTranslatedFieldSupport().renderContributions((TranslatedField)this, writer, cycle);
        this.getValidatableFieldSupport().renderContributions((ValidatableField)this, writer, cycle);
        this.renderInformalParameters(writer, cycle);
        this.renderDelegateSuffix(writer, cycle);
        if (isTextarea) {
            writer.print(value);
            writer.end();
        }
        HashMap<String, Object> scriptParms = new HashMap<String, Object>();
        Object[] params = ArrayUtils.add((Object[])DirectLink.constructServiceParameters((Object)this.getParameters()), (int)0, (Object)this.getClientId());
        AjaxDirectServiceParameter dsp = new AjaxDirectServiceParameter((IDirect)this, params, new String[]{this.getClientId()}, this.isDirect());
        scriptParms.put("updateUrl", this.getAjaxEngine().getLink(true, (Object)dsp).getAbsoluteURL());
        scriptParms.put("inputId", this.getClientId());
        scriptParms.put("updateId", this.getClientId() + "complete");
        if (this.getAfterUpdateElement() != null) {
            scriptParms.put("afterUpdateElement", this.getAfterUpdateElement());
        }
        scriptParms.put("frequency", new Double(this.getFrequency()));
        if (this.getBinding("elementclass") != null) {
            scriptParms.put("elementclass", this.getBinding("elementclass").getObject());
        }
        if (this.getOptions() != null) {
            scriptParms.put("options", this.getOptions());
        }
        if (this.isClientOnly() || this.getListener() == null) {
            String data;
            Object source = this.getListSource();
            HashMap<Object, String> clientArrays = (HashMap<Object, String>)cycle.getAttribute(CLIENT_ARRAYS_KEY);
            if (clientArrays == null) {
                clientArrays = new HashMap<Object, String>();
                cycle.setAttribute(CLIENT_ARRAYS_KEY, clientArrays);
            }
            if ((data = (String)clientArrays.get(source)) == null) {
                Iterator values = (Iterator)this.getValueConverter().coerceValue(source, Iterator.class);
                data = "new Array(" + ScriptUtils.toJsStringArray(values) + ")";
                clientArrays.put(source, scriptParms.get("updateId") + "vals");
            }
            scriptParms.put("localArray", data);
        }
        PageRenderSupport pageRenderSupport = TapestryUtils.getPageRenderSupport((IRequestCycle)cycle, (IComponent)this);
        this.getScript().execute(cycle, (IScriptProcessor)pageRenderSupport, scriptParms);
    }

    protected void rewindFormComponent(IMarkupWriter writer, IRequestCycle cycle) {
        String value = cycle.getParameter(this.getName());
        try {
            Object object = this.getTranslatedFieldSupport().parse((TranslatedField)this, value);
            this.getValidatableFieldSupport().validate((ValidatableField)this, writer, cycle, object);
            this.setValue(object);
        }
        catch (ValidatorException e) {
            this.getForm().getDelegate().record(e);
        }
    }

    protected void renderList(IMarkupWriter writer, IRequestCycle cycle) {
        Defense.notNull((Object)this.getListSource(), (String)"listSource for Autocompleter component.");
        Iterator values = (Iterator)this.getValueConverter().coerceValue(this.getListSource(), Iterator.class);
        if (this.isParameterBound("maxResults")) {
            values = new SizeRestrictingIterator(values, this.getMaxResults());
        }
        this.getListItemRenderer().renderList(writer, cycle, values);
    }

    public void trigger(IRequestCycle cycle) {
        IActionListener listener = this.getListener();
        if (listener == null) {
            throw Tapestry.createRequiredParameterException((IComponent)this, (String)"listener");
        }
        Object[] params = cycle.getListenerParameters();
        String inputId = (String)params[0];
        params[0] = cycle.getParameter(inputId);
        cycle.setListenerParameters(params);
        this.setSearchTriggered(true);
        this.getListenerInvoker().invokeListener(listener, (IComponent)this, cycle);
    }

    private void triggerClientIdGeneration(IRequestCycle cycle) {
        IMarkupWriter inst = NullWriter.getSharedInstance();
        inst.beginEmpty("a");
        this.renderIdAttribute(inst, cycle);
    }
}

