/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.ajax.components;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sf.tacos.ajax.AjaxWebRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IScript;
import org.apache.tapestry.IScriptProcessor;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.coerce.ValueConverter;
import org.apache.tapestry.engine.NullWriter;

public abstract class FisheyeList
extends BaseComponent {
    private static final Log log = LogFactory.getLog((Class)FisheyeList.class);

    public abstract int getItemWidth();

    public abstract int getItemHeight();

    public abstract int getItemMaxWidth();

    public abstract int getItemMaxHeight();

    public abstract String getOrientation();

    public abstract double getEffectUnits();

    public abstract double getItemPadding();

    public abstract String getAttachEdge();

    public abstract String getLabelEdge();

    public abstract int getBreakOn();

    public abstract Object getSource();

    public abstract ValueConverter getValueConverter();

    public abstract IScript getScript();

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        int i;
        boolean ajaxRequest = false;
        AjaxWebRequest ajaxr = (AjaxWebRequest)cycle.getAttribute("ajax-request");
        if (ajaxr != null && ajaxr.isValidRequest()) {
            ajaxRequest = true;
        }
        if (ajaxRequest && !ajaxr.containsComponentId(this.getId()) && writer instanceof NullWriter) {
            return;
        }
        writer.begin("div");
        writer.attribute("id", this.getId());
        writer.attribute("fishcontainer", "true");
        Iterator it = (Iterator)this.getValueConverter().coerceValue(this.getSource(), Iterator.class);
        int currIndex = 0;
        ArrayList fisheyeIds = new ArrayList();
        while (it.hasNext()) {
            Object currValue = it.next();
            if (this.isParameterBound("value")) {
                this.getBinding("value").setObject(currValue);
            }
            if (this.isParameterBound("index")) {
                this.getBinding("index").setObject((Object)new Integer(currIndex));
            }
            this.renderFisheye(writer, cycle, currIndex, fisheyeIds);
            super.renderBody(writer, cycle);
            ++currIndex;
        }
        writer.end();
        writer.end();
        if (ajaxRequest) {
            StringBuffer str = new StringBuffer("<script type=\"text/javascript\">\n");
            str.append("var widg;\n");
            for (i = 0; i < fisheyeIds.size(); ++i) {
                str.append("widg = dojo.widget.byId(\"").append(fisheyeIds.get(i)).append("\");\n").append("if (widg) {\n").append(" dojo.debug(\"destroying widg \");").append("widg.destroy(true);widg.destroyChildren();").append("}\n");
            }
            str.append("</script>");
            ajaxr.addPreProcessScript(str.toString());
        }
        StringBuffer fishStr = new StringBuffer("[");
        for (i = 0; i < fisheyeIds.size(); ++i) {
            fishStr.append("\"").append(fisheyeIds.get(i)).append("\"");
            if (i + 1 >= fisheyeIds.size()) continue;
            fishStr.append(",");
        }
        fishStr.append("]");
        StringBuffer propStr = new StringBuffer("{");
        for (int i2 = 0; i2 < fisheyeIds.size(); ++i2) {
            propStr.append(fisheyeIds.get(i2)).append(": {").append("id:").append("\"").append(fisheyeIds.get(i2)).append("\",");
            propStr.append("dojoType: \"FisheyeList\",").append("widgetId: \"").append(fisheyeIds.get(i2)).append("\", ").append("itemWidth: ").append(this.getItemWidth()).append(", ").append("itemHeight: ").append(this.getItemHeight()).append(", ").append("itemMaxWidth: ").append(this.getItemMaxWidth()).append(", ").append("itemMaxHeight: ").append(this.getItemMaxHeight()).append(", ").append("orientation: \"").append(this.getOrientation()).append("\", ").append("effectUnits: ").append(this.getEffectUnits()).append(", ").append("itemPadding: ").append(this.getItemPadding()).append(", ").append("attachEdge: \"").append(this.getAttachEdge()).append("\" , ").append("labelEdge: \"").append(this.getLabelEdge()).append("\"}");
            if (i2 + 1 >= fisheyeIds.size()) continue;
            propStr.append(",");
        }
        propStr.append("}");
        HashMap<String, String> scriptParms = new HashMap<String, String>();
        scriptParms.put("ajax", String.valueOf(ajaxRequest));
        scriptParms.put("fishIds", fishStr.toString());
        scriptParms.put("compId", this.getId());
        scriptParms.put("fishprops", propStr.toString());
        PageRenderSupport pageRenderSupport = TapestryUtils.getPageRenderSupport((IRequestCycle)cycle, (IComponent)this);
        this.getScript().execute(cycle, (IScriptProcessor)pageRenderSupport, scriptParms);
    }

    protected void renderFisheye(IMarkupWriter writer, IRequestCycle cycle, int currIndex, List fisheyeIds) {
        boolean breakList = this.isParameterBound("breakOn");
        if (!breakList || currIndex == 0) {
            this.renderFisheyeAttributes(writer, fisheyeIds);
            this.renderInformalParameters(writer, cycle);
            return;
        }
        int breakOn = this.getBreakOn();
        if (currIndex % breakOn == 0) {
            writer.end();
            this.renderFisheyeAttributes(writer, fisheyeIds);
            this.renderInformalParameters(writer, cycle);
        }
    }

    protected void renderFisheyeAttributes(IMarkupWriter writer, List fisheyeIds) {
        String fishId = this.getId() + fisheyeIds.size();
        fisheyeIds.add(fishId);
        writer.begin("div");
        writer.attribute("id", fishId);
        writer.attribute("dojoType", "FisheyeList");
        writer.attribute("widgetId", fishId);
        writer.attribute("itemWidth", this.getItemWidth());
        writer.attribute("itemHeight", this.getItemHeight());
        writer.attribute("itemMaxWidth", this.getItemMaxWidth());
        writer.attribute("itemMaxHeight", this.getItemMaxHeight());
        writer.attribute("orientation", this.getOrientation());
        writer.attribute("effectUnits", String.valueOf(this.getEffectUnits()));
        writer.attribute("itemPadding", String.valueOf(this.getItemPadding()));
        writer.attribute("attachEdge", this.getAttachEdge());
        writer.attribute("labelEdge", this.getLabelEdge());
    }
}

