/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.ajax.components;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IScript;
import org.apache.tapestry.IScriptProcessor;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.TapestryUtils;

public abstract class FloatingPane
extends BaseComponent {
    private static final Log log = LogFactory.getLog((Class)FloatingPane.class);

    public abstract String getTitle();

    public abstract int getMinWidth();

    public abstract int getMinHeight();

    public abstract boolean getHasShadow();

    public abstract boolean getHasToolbar();

    public abstract boolean isResizable();

    public abstract boolean getPersistPosition();

    public abstract boolean getConstrainToContainer();

    public abstract String getStyle();

    public abstract String getToggle();

    public abstract String getIdParameter();

    public abstract IAsset getIcon();

    public abstract boolean getDisplayCloseAction();

    public abstract boolean getDisplayMinimizeAction();

    public abstract boolean getDisplayMaximizeAction();

    public abstract Object getTaskBar();

    public abstract boolean getIsTaskBar();

    public abstract String getOptions();

    public abstract IScript getScript();

    public String getTaskBarId() {
        Object obj = this.getTaskBar();
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof FloatingPane) {
            return ((FloatingPane)((Object)obj)).getIdParameter();
        }
        throw new ApplicationRuntimeException("taskBar parameter should either be a String or a FloatingPane");
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        super.renderComponent(writer, cycle);
        HashMap<String, String> scriptParms = new HashMap<String, String>();
        scriptParms.put("id", this.getIdParameter());
        scriptParms.put("title", this.getTitle());
        scriptParms.put("style", this.getStyle());
        scriptParms.put("isTaskBar", String.valueOf(this.getIsTaskBar()));
        scriptParms.put("constrain", String.valueOf(this.getConstrainToContainer()));
        scriptParms.put("resizable", String.valueOf(this.isResizable()));
        scriptParms.put("persistPosition", String.valueOf(this.getPersistPosition()));
        scriptParms.put("toggle", this.getToggle());
        scriptParms.put("displayCloseAction", String.valueOf(this.getDisplayCloseAction()));
        scriptParms.put("displayMaximizeAction", String.valueOf(this.getDisplayMaximizeAction()));
        scriptParms.put("displayMinimizeAction", String.valueOf(this.getDisplayMinimizeAction()));
        if (this.getIcon() != null) {
            scriptParms.put("iconSrc", this.getIcon().buildURL());
        }
        if (this.getTaskBar() != null) {
            scriptParms.put("taskBar", this.getTaskBarId());
        }
        scriptParms.put("hasShadow", String.valueOf(this.getHasShadow()));
        PageRenderSupport pageRenderSupport = TapestryUtils.getPageRenderSupport((IRequestCycle)cycle, (IComponent)this);
        this.getScript().execute(cycle, (IScriptProcessor)pageRenderSupport, scriptParms);
    }

    public int getContentHeight() {
        int height = 100;
        if (this.getHasToolbar()) {
            height = 95;
        }
        return height;
    }
}

